% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/boxcarDetrend.R
\name{boxcarDetrend}
\alias{boxcarDetrend}
\title{Boxcar filter detrending of a time series}
\usage{
boxcarDetrend(f, w, acqTime, nIntervals, plot = TRUE)
}
\arguments{
\item{f}{A vector}

\item{w}{Size of the time window of the moving average}

\item{acqTime}{Point acquisition rate (in seconds).}

\item{nIntervals}{Number of intervals into which the moving average vector will be grouped.}

\item{plot}{Boolean, set to TRUE (default) to plot the result}
}
\value{
Detrended version of 'f'
}
\description{
Performs the boxcar filter detrending algorithm over a vector
}
\details{
First, an amount of zeroes equal to (w-1) is added at the tail of 'f' to compensate for the moving average
effect when position (length(f) - w + 1) is reached. The moving average is then calculated and subtracted from the
original vector 'f' to obtain the residuals. The moving average vector is then binned and the first value of the
resulting vector is used as the lambda parameter for a Poisson distribution from which integer numbers will be
randomly sampled and added to the residuals vector for trend correction.
}
\examples{
\donttest{
### Please navigate to
### (https://github.com/FCSlib/FCSlib/tree/master/Sample\%20Data)
### to find this sample data

x <- read.table("PB030.dat", header = F)

x.d <- boxcarDetrend(x[,2], w = 100, acqTime = 4e-6, nIntervals = 100, plot = TRUE)
}
}
\seealso{
\code{\link{expDetrend} \link{polyDetrend} \link{binTimeSeries}}
}
\author{
Alejandro Linares, Adan Guerrero, Haydee Hernández
}
