% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/metaheuristic.R
\name{aco}
\alias{aco}
\title{Ant Colony Optimization (Advanced Binary Ant Colony Optimization)}
\usage{
aco(data, class, featureSetEval, population = 10, iter = 10, a = 1,
  b = 1, p = 0.2, q = 1, t0 = 0.2, tmin = 0, tmax = 1,
  mode = 1, verbose = FALSE)
}
\arguments{
\item{data}{\itemize{
\item A data frame with the features and the class of the examples. All features must contain numerical values and not character, boolean, or factor type values since heuristics work only with numerical values. Otherwise the algorithm will generate error.
}}

\item{class}{\itemize{
\item The name of the dependent variable
}}

\item{featureSetEval}{\itemize{
\item The measure for evaluate features
}}

\item{population}{\itemize{
\item The number of ants population
}}

\item{iter}{\itemize{
\item The number of iterations
}}

\item{a}{\itemize{
\item Parameter to control the influence of the pheromone (If a=0, no pheromone information is used)
}}

\item{b}{\itemize{
\item Parameter to control the influence of the heuristic (If b=0, the attractiveness of the movements is not taken into account)
}}

\item{p}{\itemize{
\item Rate of pheromone evaporation
}}

\item{q}{\itemize{
\item Constant to determine the amount of pheromone deposited by the best ant. This amount is determined by the Q/F equation (for minimization) where F is the cost of the solution (F/Q for maximization)
}}

\item{t0}{\itemize{
\item Initial pheromone level
}}

\item{tmin}{\itemize{
\item Minimum pheromone value
}}

\item{tmax}{\itemize{
\item Maximum pheromone value
}}

\item{mode}{\itemize{
\item Heuristic information measurement. 1 -> min redundancy (by default). 2-> max-relevance and min-redundancy. 3-> feature-feature. 4-> based on F-score
}}

\item{verbose}{\itemize{
\item Print the partial results in each iteration
}}
}
\value{
A list is returned containing for each repetition of the algorithm:
\describe{
\item{bestFeatures}{A vector with all features. Selected features are marked with 1, unselected features are marked with 0}
\item{bestFitness}{Evaluation measure obtained with the feature selection}
\item{antsIter}{List that contains as many elements as iterations has the algorithm. Each of the elements in the list are matrices that represent the population in that iteration. In this matrix the individuals and the evaluation measure of each one are shown}
\item{pheromoneIter}{List that contains as many elements as iterations have the algorithm. Each of the elements in the list are matrices that represent the amount of pheromone between the paths of the different features (the reading of the matrix is from the columns to the rows, i.e. from top to bottom) in each iteration}
}
}
\description{
The Ant Colony Optimization (Advanced Binary Ant Colony Optimization) \insertCite{Kashef2015}{FSinR} algorithm consists of generating in each iteration a random population of individuals (ants) according to the values of a pheromone matrix (which is updated each iteration according to the paths most followed by the ants) and a heuristic (which determines how good is each path to follow by the ants). The evaluation measure is calculated for each individual. The algorithm ends once the established number of iterations has been reached
}
\examples{
## Ant Colony Optimization for iris dataset (filter method)
aco(iris, 'Species', roughsetConsistency, population = 10, iter = 5, verbose = TRUE)
}
\references{
\insertAllCited{}
}
\author{
Francisco Aragón Royón
}
