% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/metaheuristic.R
\name{ga}
\alias{ga}
\title{Genetic Algorithm}
\usage{
ga(data, class, featureSetEval, popSize = 20, pcrossover = 0.8,
  pmutation = 0.1, maxiter = 100, run = 100, verbose = FALSE)
}
\arguments{
\item{data}{\itemize{
\item A data frame with the features and the class of the examples
}}

\item{class}{\itemize{
\item The name of the dependent variable
}}

\item{featureSetEval}{\itemize{
\item The measure for evaluate features
}}

\item{popSize}{\itemize{
\item The popuplation size
}}

\item{pcrossover}{\itemize{
\item The probability of crossover between individuals
}}

\item{pmutation}{\itemize{
\item The probability of mutation between individuals
}}

\item{maxiter}{\itemize{
\item The number of iterations
}}

\item{run}{\itemize{
\item Number of consecutive iterations without fitness improvement to stop the algorithm
}}

\item{verbose}{\itemize{
\item Print the partial results in each iteration. This functionality is not available if the objective of the evaluation method is to minimize the target value (e.g. regression methods)
}}
}
\value{
A list is returned containing for each repetition of the algorithm:
\describe{
\item{bestFeatures}{A vector with all features. Selected features are marked with 1, unselected features are marked with 0}
\item{bestFitness}{Evaluation measure obtained with the feature selection}
\item{population}{Matrix with the population of the last iteration of the algorithm along with the evaluation measure of each individual}
}
}
\description{
The ga method \insertCite{yang1998feature}{FSinR} starts with an initial population of solutions and at each step applies a series of operators to the individuals in order to obtain new and better population of individuals. These operators are selection, crossing and mutation methods. This method uses the GA package implementation \insertCite{GAPkg1}{FSinR} \insertCite{GAPkg2}{FSinR}.
}
\examples{
## Genetic algorithm for iris dataset (filter method)
ga(iris, 'Species', roughsetConsistency, popSize = 10, maxiter=5, verbose=TRUE)
}
\references{
\insertAllCited{}
}
\author{
Francisco Aragón Royón
}
