% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/PlotAges.R
\name{PlotAges}
\alias{PlotAges}
\title{Plots age distribution(s) of kin}
\usage{
PlotAges(d, xmin = NULL, xmax = NULL, ymax = NULL, legendPos = NULL)
}
\arguments{
\item{d}{Dataframe with at least the following columns: 
\itemize{
 \item ID
 \item Age
 \item Case. Case is the population category for which age distribution should be drawn (e.g. male, female).
}}

\item{xmin}{Minimum age to be displayed on x-axis}

\item{xmax}{Maximum age to be displayed on x-axis}

\item{ymax}{Maximum value on y-axis (minimum is 0)}

\item{legendPos}{Position of legend (position is indicated according to ggplot2 rule)}
}
\value{
\item{p}{syntax to plot age distribution(s)}
}
\description{
Plots one or more age distributions of kin (e.g. males, females; mothers, grandmothers)
}
\examples{
# Load data
data(dLH,package="Families")
# Age of mother at birth of a child
idego=dLH$ID[dLH$gen==1 & dLH$sex=="Female"]
idch <- IDch(idego,d=dLH)
agem <- dLH$bdated[idch]  - dLH$bdated[IDmother(idch,d=dLH)]
dm <- data.frame(idego=IDmother(idch),Age=agem)
dm$Case <- "Motherhood"

# Age at grandmotherhood
idgch <- IDch(IDch(idego,d=dLH),d=dLH)
agegm <- dLH$bdated[idgch] - dLH$bdated[IDmother(IDmother(idgch,d=dLH),d=dLH)]
dgm <- data.frame(idego=IDmother(IDmother(idgch,d=dLH),d=dLH),Age=agegm)
dgm$Case <- "Grandmotherhood"
d <- rbind (dm,dgm)
d <- d[!is.na(d$Age),]
binwidth <- (max(d$Age,na.rm=TRUE)-min(d$Age,na.rm=TRUE))/60
cas <- unique(d$Case)
d$Case <- factor(d$Case,levels=cas,labels=cas,ordered=TRUE)
library(ggplot2)
p <- PlotAges(d)

}
