% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/load.R
\name{print.farm.scree}
\alias{print.farm.scree}
\title{Summarize and print the results of the eignevalue ratio test}
\usage{
\method{print}{farm.scree}(x, ...)
}
\arguments{
\item{x}{A "farm.scree" object.}

\item{\dots}{Further arguments passed to or from other methods.}
}
\value{
Summarizes the results of the factor-finding step.
}
\description{
Print method for farm.scree objects.
}
\examples{
set.seed(100)
p = 100
n = 20
epsilon = matrix(rnorm( p*n, 0,1), nrow = n)
B = matrix(rnorm(p*3,0,1), nrow=p)
fx = matrix(rnorm(3*n, 0,1), nrow = n)
X = fx\%*\%t(B)+ epsilon
output = farm.scree(X)
output
}
\seealso{
\code{\link{farm.scree}} and \code{\link{plot.farm.scree}}
}
