% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/FastHamming.R
\name{hamming_distance}
\alias{hamming_distance}
\title{Pairwise Hamming distances}
\usage{
hamming_distance(X, nthreads = NULL)
}
\arguments{
\item{X}{A binary (0/1) numeric matrix.}

\item{nthreads}{Integer; number of OpenMP threads to use. If \code{NULL} (the default) use all available cores,}
}
\value{
An integer matrix of pairwise Hamming distances.
}
\description{
Computes the pairwise Hamming distances between rows of a binary matrix.
}
\examples{
\donttest{
n <- 10000
m <- 1000
set.seed(2468)
X <- matrix(sample(0:1, n * m, replace = TRUE), nrow = n)
# Use all available threads
system.time(result <- hamming_distance(X))
# limit to 2 threads
system.time(hamming_distance(X, nthreads = 2))
}
}
