% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot.survfitjmcs.R
\name{plot.survfitjmcs}
\alias{plot.survfitjmcs}
\title{Plot survival probabilities for new subjects}
\usage{
\method{plot}{survfitjmcs}(
  x,
  estimator = c("both", "mean", "median"),
  conf.int = TRUE,
  include.y = FALSE,
  ...
)
}
\arguments{
\item{x}{x of class \code{survfitjmcs}.}

\item{estimator}{character string specifying, whether to include in the plot 
the mean of the conditional probabilities of survival, the median or both. 
The mean and median are taken as estimates of these conditional probabilities 
over the M replications of the Monte Carlo scheme described in \code{survfitjmcs}.}

\item{conf.int}{logical; if TRUE, then a pointwise confidence interval is included in the plot. Default is TRUE.}

\item{include.y}{include longitudinal responses of this subject versus time. Default is FALSE.}

\item{...}{further arguments passed to or from other methods.}
}
\value{
plots of conditional probabilities over different pre-specified time points for subjects. 
If single failure type, then survival probabilities will be returned. 
Otherwise, cumulative incidence probabilities for each failure type will be returned.
}
\description{
Plot survival probabilities for new subjects.
}
\examples{
\donttest{
# a joint model fit
fit <- jmcs(ydata = ydata, cdata = cdata, 
long.formula = response ~ time + x1, 
surv.formula = Surv(surv, failure_type) ~ x1 + x2, 
random =  ~ time| ID)

# Prediction of cumulative incidence for competing risks data
ND <- ydata[ydata$ID \%in\% c(419, 218), ]
ID <- unique(ND$ID)
NDc <- cdata[cdata$ID  \%in\% ID, ]
survfit <- survfitjmcs(fit, 
                       ynewdata = ND, 
                       cnewdata = NDc, 
                       u = seq(3, 4.8, by = 0.2), 
                       M = 100)
                       
oldpar <- par(mfrow = c(2, 2))
plot(survfit, estimator = "both", include.y = TRUE)
par(oldpar)
}
}
\seealso{
\code{\link{survfitjmcs}}
}
\author{
Shanpeng Li \email{lishanpeng0913@ucla.edu}
}
