% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/packageLoading.R
\name{createPkgLoader}
\alias{createPkgLoader}
\title{Create Package Loader Function}
\usage{
createPkgLoader(lib = .libPaths()[1])
}
\arguments{
\item{lib}{A character vector specifying the library directory for package
installation of the output function. Defaults to the current default
package installation directory in \code{.libPaths()[1]}}
}
\value{
A function that installs and loads packages.
}
\description{
\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#experimental}{\figure{lifecycle-experimental.svg}{options: alt='[Experimental]'}}}{\strong{[Experimental]}}

This function creates a package loader function that can install and load packages
from CRAN, Bioconductor, or GitHub, optionally displaying verbose output.
This function can be useful in new R instances with little dependencies
available.

The function takes the following arguments:
\itemize{
\item \code{cran}
\item \code{bioc}
\item \code{gh}
\item \code{verbose}
}

where cran\code{and}bioc\verb{take character vectors of package names on CRAN and Bioconductor, while}gh\verb{takes character vectors with the formatting}githubUsername/packageName\code{. }verbose` takes in a logical for whether
to display additional informative messages in the REPL.

The function will not install packages that can already be loaded by
default.
}
\examples{
# Create the package loader function
loader <- createPkgLoader()

# # commented usage example
# loader(
#   cran = c("dplyr", "ggplot2"),
#   bioc = c("GenomicRanges", "Biobase"),
#   gh = c("tidyverse/dplyr"),
#   verbose = FALSE
# )

}
\keyword{packageLoading}
