% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/l_estimation.R
\name{checkquantiles}
\alias{checkquantiles}
\title{Check Quantiles and Probabilities}
\usage{
checkquantiles(x, proba = FALSE, acceptNA = FALSE)
}
\arguments{
\item{x}{vector of quantiles.}

\item{proba}{boolean. if TRUE, check range (0,1).}

\item{acceptNA}{boolean.}
}
\description{
Check that quantiles (or probabilities) are all
different from each other and correctly ordered.
If \code{proba = TRUE}, check that values are in range (0, 1).
}
\examples{
lst <- list(
  0.8,
  c(0.1, 0.5, 0.8),
  c(0.1, 0.5, 0.8, 0.2),
  c(2, 3, 1),
  c(2, 3),
  -0.01,
  NA,
  c(NA, NA),
  c(0.1, NA),
  c(0.1, NA, 0.5, 0.8),
  c(0.1, NA, 0.8, NA, 0.5),
  c(12, NA)
)

## Evaluate
for (i in seq_along(lst)) {
  cat(i, lst[[i]], " : ",
      checkquantiles(lst[[i]], proba = FALSE),
      checkquantiles(lst[[i]], proba = TRUE),
      checkquantiles(lst[[i]], proba = FALSE, acceptNA = TRUE),
      checkquantiles(lst[[i]], proba = TRUE,  acceptNA = TRUE),
	     "\\n")
}

## Not run:
checkquantiles(matrix((1:12)/16, ncol=3), proba = TRUE)
## End(Not run)
}

