% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/unstructured_gxe.R
\name{unstr_asr_output}
\alias{unstr_asr_output}
\title{Simulate genetic values based on an unstructured model for GxE interaction -
Simulation using 'AlphaSimR'}
\usage{
unstr_asr_output(pop, n_envs, n_traits, n_reps)
}
\arguments{
\item{pop}{An \href{https://CRAN.R-project.org/package=AlphaSimR}{'AlphaSimR'} population object
(\href{https://gaynorr.github.io/AlphaSimR/reference/Pop-class.html}{Pop-class} or
\href{https://gaynorr.github.io/AlphaSimR/reference/HybridPop-class.html}{HybridPop-class})
generated using \link[FieldSimR]{unstr_asr_input}.}

\item{n_envs}{Number of simulated environments (same number used in \link[FieldSimR]{unstr_asr_input}).}

\item{n_traits}{Number of simulated traits (same number used in \link[FieldSimR]{unstr_asr_input}).}

\item{n_reps}{A vector defining the number of complete replicates (blocks) in each environment.
If only one value is specified, all environments will be assigned the same number.}
}
\value{
A data frame with columns 'env', 'rep', genotype 'id', and the
  simulated genetic values for each trait.
}
\description{
Creates a data frame of simulated genetic values for multiple traits across multiple environments
based on an unstructured model for genotype-by-environment (GxE) interaction. This function
requires an \href{https://CRAN.R-project.org/package=AlphaSimR}{'AlphaSimR'} population object
generated using the \link[FieldSimR]{unstr_asr_input} function.
}
\examples{
# Simulate genetic values in 'AlphaSimR' for two additive + dominance traits across
# three environments based on an unstructured model for GxE interaction.

# 1. Define the genetic architecture of the simulated traits.
# Mean genetic values and mean dominance degrees.
mean <- c(4.9, 5.4, 5.1, 235.2, 228.5, 239.1) # Trait 1 x 3 environments, trait 2 x 3 environments.
mean_DD <- c(0.4, 0.4, 0.4, 0.1, 0.1, 0.1) # Trait 1 and 2, same values in the three environments.

# Additive genetic variances and dominance degree variances.
var <- c(0.085, 0.12, 0.06, 15.1, 8.5, 11.7) # Trait 1 x 3 environments, trait 2 x 3 environments.
var_DD <- rep(0.2, 6) # The same value set for traits 1 and 2.

# Additive genetic correlations between the two simulated traits.
T_cor_A <- matrix(
  c(
    1.0, 0.6,
    0.6, 1.0
  ),
  ncol = 2
)

# Additive genetic correlations between the three simulated environments.
E_cor_A <- matrix(
  c( # Matrix of additive genetic correlations between the three environments.
    1.0, 0.4, 0.6,
    0.4, 1.0, 0.5,
    0.6, 0.5, 1.0
  ),
  ncol = 3
)

# Dominance degree correlations between all six environment-within-trait combinations.
cor_DD <- diag(6) # Assuming independence between traits

input_asr <- unstr_asr_input(
  n_envs = 3,
  n_traits = 2,
  mean = mean,
  var = var,
  T_cor_A = T_cor_A,
  E_cor_A = E_cor_A,
  mean_DD = mean_DD,
  var_DD = var_DD,
  cor_DD = cor_DD
)


# 2. Use input_asr to simulate genetic values in 'AlphaSimR' based on an unstructured model for
# GxE interaction.

library("AlphaSimR")
FOUNDERPOP <- quickHaplo(
  nInd = 100,
  nChr = 6,
  segSites = 100
)

SP <- SimParam$new(FOUNDERPOP)

SP$addTraitAD(
  nQtlPerChr = 100,
  mean = input_asr$mean,
  var = input_asr$var,
  meanDD = input_asr$mean_DD,
  varDD = input_asr$var_DD,
  corA = input_asr$cor_A,
  corDD = input_asr$cor_DD,
  useVarA = TRUE
)

# By default, the value provided in 'var' represents the additive variance.
# If useVarA=FALSE, 'var' represents the total genetic variance.

pop <- newPop(FOUNDERPOP)


# 3. Create a data frame containing the simulated genetic values for the two traits across the
# three environments.

n_reps <- c(3, 3, 2) # Vector containing the number of complete replicates in each environment.

gv_df <- unstr_asr_output(
  pop = pop,
  n_envs = 3,
  n_traits = 2,
  n_reps = n_reps
)
}
