% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/04.FF_either.R
\name{FF.norm.management}
\alias{FF.norm.management}
\title{Create a normalised-valued firm-firm (FF) matrix for boards interlocks}
\usage{
FF.norm.management(
  ...,
  id_as_firm_name = NULL,
  Matrix = NULL,
  self_ties = FALSE
)
}
\arguments{
\item{...}{Either multiple objects of class \code{firm} or a list of such objects}

\item{id_as_firm_name}{Whether to use the ticker as the firm's name. Defaults to \code{TRUE} if all firms' id is neither \code{NULL} nor \code{NA}.}

\item{Matrix}{Whether to use the \href{https://cran.r-project.org/package=Matrix}{\code{Matrix} package}. Defaults to \code{TRUE} when any matrix in the pipeline contains more than 10,000 cells and the package is installed.}

\item{self_ties}{Whether to allow self-ties (a 'loop' in graph theory). Defaults to \code{FALSE}.}
}
\value{
A matrix object of class \code{financial_matrix}(possibly using the \href{https://cran.r-project.org/package=Matrix}{\code{Matrix} package})
}
\description{
Function to create a normalised-valued firm-firm (FF) matrix based on boards interlocks
}
\details{
Normalised-valued means that weights represent the share of common managers.
}
\examples{

# Create the normalised FF matrix of Berkshire Hathaway's holdings by boards interlocks
data('firms_BKB')
FF <- FF.norm.management(firms_BKB)

}
\seealso{
\link{FF} \link{FF.binary.ownership} \link{FF.binary.management} \link{FF.naive.ownership} \link{FF.naive.management} \link{FF.norm.ownership}
}
\author{
\enc{Telarico, Fabio Ashtar}{Fabio Ashtar Telarico}
}
