% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/extract.slope.R
\name{extract.slope}
\alias{extract.slope}
\title{Extraction of Slope(s)}
\usage{
extract.slope(clean.data, method = c("min", "max"),
              n.slope=1000, r2=0.9, length = 9999,
              plot.data = TRUE)
}
\arguments{
\item{clean.data}{a data frame obtained by using the function \code{\link{correct.meas}}}
\item{method}{string: the method of extracting slopes: minimal or maximal values}
\item{n.slope}{integer: the number of extracted slopes (only one slope is calculated for each measurement period)}
\item{r2}{numeric: minimal coeficient of determination (r2) for extracted slopes. Coeficient of determination is used as a threshold of quality to be determined by the user.}
\item{length}{integer: length of a measurement period for slope calculations (in seconds)}
\item{plot.data}{logical: if TRUE, then a graph with raw data for extracted slopes is plotted}
}
\value{
The function returns a data frame with the information about extracted slopes. The data frame is used in the functions \code{\link{QC.slope}} and \code{\link{calculate.MR}}.
}
\description{
The function extracts the slopes of the linear regression
of corrected O2 concenration over time with defined parameters
(see Arguments).
}
\examples{
# if the data have been already loaded to R,
# skip the first three lines of the code:
setwd(path.package("FishResp", quiet = FALSE))
load("data/SMR.clean.RData")
load("data/AMR.clean.RData")

SMR.slope <- extract.slope(SMR.clean,
                           method = "min",
                           n.slope = 3,
                           r2=0.95,
                           length = 1200,
                           plot.data = TRUE)

AMR.slope <- extract.slope(AMR.clean,
                           method = "max",
                           n.slope = 3,
                           r2=0.8,
                           length = 300,
                           plot.data = TRUE)

}
