% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/predicted_residuals.R
\name{predict.flexreg}
\alias{predict.flexreg}
\title{Prediction Method for flexreg Objects}
\usage{
\method{predict}{flexreg}(
  object,
  newdata = NULL,
  cluster = F,
  type = "response",
  estimate = "mean",
  q = NULL,
  ...
)
}
\arguments{
\item{object}{an object of class \code{`flexreg`}, usually the result of \code{\link{flexreg}}.}

\item{newdata}{an optional data frame containing variables with which to predict. If omitted, the fitted values are used.}

\item{cluster}{if the model is \code{"FB"}, \code{cluster = T} returns the cluster means. By default, \code{cluster = F}.}

\item{type}{a character indicating the type of predictions. Available options are the  fitted means of response (\code{response}), the linear predictor (\code{link}),
the fitted precision parameter phi (\code{precision}), and the fitted variances of the response (\code{variance}).}

\item{estimate}{the type of estimate: \code{mean} (default), \code{median} or \code{quantile}.}

\item{q}{if estimate is \code{quantile}, numeric value of probability in (0, 1).}

\item{...}{additional arguments. Currently not used.}
}
\description{
Method that computes various types of prediction from objects of class \code{`flexreg`}. If the model type is \code{FB} and \code{cluster = T}, the function returns also cluster means.
}
\examples{
{
data("Reading")
FB <- flexreg(accuracy ~ iq, Reading, type="FB", n.iter=1000)
predict(FB, type="response", cluster=TRUE)
}

}
