% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/densities.R
\name{dBetaBin}
\alias{dBetaBin}
\title{Probability mass function of the beta-binomial distribution}
\usage{
dBetaBin(x, size, mu, theta = NULL, phi = NULL)
}
\arguments{
\item{x}{a vector of quantiles.}

\item{size}{the total number of trials.}

\item{mu}{the mean parameter. It must lie in (0, 1).}

\item{theta}{the overdispersion parameter. It must  lie in (0, 1).}

\item{phi}{the precision parameter, an alternative way to specify the overdispersion parameter \code{theta}. It must be a real positive value.}
}
\value{
A vector with the same length as \code{x}.
}
\description{
The function computes the probability mass function of the beta-binomial distribution.
}
\details{
The beta-binomial distribution has probability mass function
\deqn{f_{BB}(x;\mu,\phi)={n\choose x} \frac{\Gamma{(\phi)}}{\Gamma{(\mu\phi)}\Gamma{((1-\mu)\phi)}} \frac{\Gamma{(\mu\phi+x)}\Gamma{((1-\mu)\phi + n - x)}}{\Gamma{(\phi + n)}},}
for \eqn{x \in \lbrace 0, 1, \dots, n \rbrace}, where \eqn{0<\mu<1} identifies the mean and \eqn{\phi=(1-\theta)/\theta >0} is the precision parameter.
}
\examples{
dBetaBin(x = 5, size = 10, mu = .3, phi = 10)

}
\references{
{
Ascari, R., Migliorati, S. (2021). A new regression model for overdispersed binomial data accounting for outliers and an excess of zeros. Statistics in Medicine, \bold{40}(17), 3895--3914. doi:10.1002/sim.9005
}
}
