% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/octrec.R
\name{octrec}
\alias{octrec}
\title{Optimal combination cross-temporal forecast reconciliation}
\usage{
octrec(basef, m, C, comb, res, Ut, nb, mse = TRUE,
       corpcor = FALSE, type = "M", sol = "direct", keep = "list",
       nn = FALSE, nn_type = "osqp", settings = list(),
       bounds = NULL, W = NULL, Omega = NULL)
}
\arguments{
\item{basef}{(\mjseqn{n \times h(k^\ast+m)}) matrix of base forecasts to be
reconciled, \mjseqn{\widehat{\mathbf{Y}}}; \mjseqn{n} is the total number of variables,
\mjseqn{m} is the highest time frequency, \mjseqn{k^\ast} is the sum of (a
subset of) (\mjseqn{p-1}) factors of \mjseqn{m}, excluding \mjseqn{m}, and
\mjseqn{h} is the forecast horizon for the lowest frequency time series.
Each row identifies a time series, and the forecasts are ordered as
[lowest_freq' ...  highest_freq']'.}

\item{m}{Highest available sampling frequency per seasonal cycle (max. order
of temporal aggregation, \mjseqn{m}), or a subset of \mjseqn{p} factors
of \mjseqn{m}.}

\item{C}{(\mjseqn{n_a \times n_b}) cross-sectional (contemporaneous) matrix
mapping the bottom level series into the higher level ones.}

\item{comb}{Type of the reconciliation. It corresponds to a specific
(\mjseqn{n(k\ast + m) \times n(k^\ast + m)}) covariance matrix, where
\mjseqn{k^\ast} is the sum of (a subset of) (\mjseqn{p-1}) factors of
\mjseqn{m} (\mjseqn{m} is not considered) and \mjseqn{n} is the number
of variables:
\itemize{
  \item \bold{ols} (Identity);
  \item \bold{struc} (Cross-temporal summing matrix);
  \item \bold{wlsh} (Hierarchy variances matrix);
  \item \bold{wlsv} (Series variances matrix);
  \item \bold{bdshr} (Shrunk cross-covariance matrix, cross-sectional framework);
  \item \bold{bdsam}  (Sample cross-covariance matrix, cross-sectional framework);
  \item \bold{acov} (Series auto-covariance matrix);
  \item \bold{Sshr} (Series shrunk cross-covariance matrix);
  \item \bold{Ssam} (Series cross-covariance matrix);
  \item \bold{shr}  (Shrunk cross-covariance matrix);
  \item \bold{sam} (Sample cross-covariance matrix);
  \item \bold{w} use your personal matrix W in param \code{W};
  \item \bold{omega} use your personal matrix Omega in param \code{Omega}.
}}

\item{res}{(\mjseqn{n \times N(k^\ast + m)}) matrix containing the residuals at
all the temporal frequencies ordered [lowest_freq' ...  highest_freq']'
(columns) for each variable (row), needed to estimate the covariance matrix
when \code{comb =} \code{\{"sam",} \code{"wlsv",} \code{"wlsh",}
\code{"acov",} \code{"Ssam",} \code{"Sshr",} \code{"Sshr1",} \code{"shr"\}}.}

\item{Ut}{Zero constraints cross-sectional (contemporaneous) kernel matrix
\mjseqn{(\textbf{U}'\textbf{y} = \mathbf{0})} spanning the null space valid
for the reconciled forecasts. It can be used instead of parameter
\code{C}, but \code{nb} (\mjseqn{n = n_a + n_b}) is needed if
\mjseqn{\textbf{U}' \neq [\textbf{I} \ -\textbf{C}]}. If the hierarchy
admits a structural representation, \mjseqn{\textbf{U}'} has dimension
(\mjseqn{n_a \times n}).}

\item{nb}{Number of bottom time series; if \code{C} is present, \code{nb}
and \code{Ut} are not used.}

\item{mse}{Logical value: \code{TRUE} (\emph{default}) calculates the
covariance matrix of the in-sample residuals (when necessary) according to
the original \pkg{hts} and \pkg{thief} formulation: no mean correction,
T as denominator.}

\item{corpcor}{Logical value: \code{TRUE} if \pkg{corpcor} (\enc{Schäfer}{Schafer} et
al., 2017) must be used to shrink the sample covariance matrix according to
\enc{Schäfer}{Schafer} and Strimmer (2005), otherwise the function uses the
same implementation as package \pkg{hts}.}

\item{type}{Approach used to compute the reconciled forecasts: \code{"M"} for
the projection approach with matrix M (\emph{default}), or \code{"S"} for the
structural approach with summing matrix S.}

\item{sol}{Solution technique for the reconciliation problem: either
\code{"direct"} (\emph{default}) for the closed-form matrix solution, or
\code{"osqp"} for the numerical solution (solving a linearly constrained
quadratic program using \code{\link[osqp]{solve_osqp}}).}

\item{keep}{Return a list object of the reconciled forecasts at all levels
(if keep = "list") or only the reconciled forecasts matrix (if keep = "recf").}

\item{nn}{Logical value: \code{TRUE} if non-negative reconciled forecasts
are wished.}

\item{nn_type}{"osqp" (default), "KAnn" (only \code{type == "M"}) or "sntz".}

\item{settings}{Settings for \pkg{osqp} (object \code{\link[osqp]{osqpSettings}}).
The default options are: \code{verbose = FALSE}, \code{eps_abs = 1e-5},
\code{eps_rel = 1e-5}, \code{polish_refine_iter = 100} and \code{polish = TRUE}.
For details, see the \href{https://osqp.org/}{\pkg{osqp} documentation}
(Stellato et al., 2019).}

\item{bounds}{(\mjseqn{n(k^\ast + m) \times 2}) matrix of the bounds on the
variables: the first column is the lower bound, and the second column is the
upper bound.}

\item{W, Omega}{This option permits to directly enter the covariance matrix:
\enumerate{
  \item \code{W} must be a p.d. (\mjseqn{n(k^\ast + m) \times n(k^\ast + m)})
  matrix or a list of \mjseqn{h} matrix (one for each forecast horizon);
  \item \code{Omega} must be a p.d. (\mjseqn{n(k^\ast + m) \times n(k^\ast + m)})
  matrix or a list of \code{h} matrix (one for each forecast horizon);
  \item if \code{comb} is different from "\code{w}" or "\code{omega}",
  \code{W} or \code{Omega} is not used.
}}
}
\value{
If the parameter \code{keep} is equal to \code{"recf"}, then the function
returns only the (\mjseqn{n \times h(k^\ast + m)}) reconciled forecasts
matrix, otherwise (\code{keep="all"}) it returns a list that mainly depends
on what type of representation (\code{type}) and solution technique
(\code{sol}) have been used:
\item{\code{recf}}{(\mjseqn{n \times h(k^\ast + m)}) reconciled forecasts matrix, \mjseqn{\widetilde{\textbf{Y}}}.}
\item{\code{Omega}}{Covariance matrix used for reconciled forecasts (\mjseqn{\mbox{vec}(\widehat{\textbf{Y}}')} representation).}
\item{\code{W}}{Covariance matrix used for reconciled forecasts (\mjseqn{\mbox{vec}(\widehat{\textbf{Y}})} representation).}
\item{\code{nn_check}}{Number of negative values (if zero, there are no values below zero).}
\item{\code{rec_check}}{Logical value: \code{rec_check = TRUE} when the constraints have been fulfilled,}
\item{\code{varf} (\code{type="direct"})}{(\mjseqn{n \times (k^\ast + m)}) reconciled forecasts variance matrix for \mjseqn{h=1}, \mjseqn{\mbox{diag}(\mathbf{MW}}).}
\item{\code{M} (\code{type="direct"})}{Projection matrix (projection approach).}
\item{\code{G} (\code{type="S"} and \code{type="direct"})}{Projection matrix (structural approach, \mjseqn{\mathbf{M}=\mathbf{S}\mathbf{G}}).}
\item{\code{S} (\code{type="S"} and \code{type="direct"})}{Cross-temporal summing matrix (\mjseqn{\widetilde{\textbf{S}}\mbox{vec}(\widehat{\textbf{Y}}')} representation).}
\item{\code{info} (\code{type="osqp"})}{matrix with some useful indicators (columns)
for each forecast horizon \mjseqn{h} (rows): run time (\code{run_time}), number of iteration,
norm of primal residual (\code{pri_res}), status of osqp's solution (\code{status}) and
polish's status (\code{status_polish}).}
}
\description{
\loadmathjax
Optimal (in least squares sense) combination cross-temporal forecast
reconciliation. The reconciled forecasts are calculated either through a
projection approach (Byron, 1978), or the equivalent structural approach
by Hyndman et al. (2011).
}
\details{
\loadmathjax
Considering contemporaneous and temporal dimensions in the
same framework requires to extend and adapt the notations
used in \link[FoReco]{htsrec} and \link[FoReco]{thfrec}.
To do that, we define the matrix containing the base forecasts
at any considered temporal frequency as
\mjsdeqn{
\widehat{\textbf{Y}}_{n \times h(k^\ast+m))} =
\left[\begin{array}{ccccc}
\widehat{\textbf{A}}^{[m]} & \widehat{\textbf{A}}^{[k_{p-1}]} & \cdots &
\widehat{\textbf{A}}^{[k_2]} & \widehat{\textbf{A}}^{[1]} \cr
\widehat{\textbf{B}}^{[m]} & \widehat{\textbf{B}}^{[k_{p-1}]} & \cdots &
\widehat{\textbf{B}}^{[k_2]} & \widehat{\textbf{B}}^{[1]}
\end{array}
\right] \qquad k \in {\cal K},}
where \mjseqn{\cal K} is a subset of \mjseqn{p} factors of \mjseqn{m} and,
\mjseqn{\widehat{\textbf{B}}^{[k]}} and \mjseqn{\widehat{\textbf{A}}^{[k]}}
are the matrices containing the \mjseqn{k}-order temporal aggregates of the
bts and uts, of dimension (\mjseqn{n_b \times h m/k}) and
(\mjseqn{n_a \times h m/k}), respectively.

Let us consider the multivariate regression model
\mjsdeqn{\widehat{\mathbf{Y}} = \mathbf{Y} + \mathbf{E} ,}
where the involved matrices have each dimension
\mjseqn{[n \times (k^\ast+m)]} and contain, respectively, the base
(\mjseqn{\widehat{\mathbf{Y}}}) and the target forecasts
(\mjseqn{\mathbf{Y}}), and the coherency errors (\mjseqn{\mathbf{E}}) for
the \mjseqn{n} component variables of the linearly constrained time series
of interest. For each variable, \mjseqn{k^\ast + m} base forecasts are
available, pertaining to all aggregation levels of the temporal hierarchy
for a complete cycle of high-frequency observation, \mjseqn{m}. Consider
now two vectorized versions of model, by transforming the matrices either
in original form:
\mjsdeqn{\mbox{vec}\left(\widehat{\mathbf{Y}}\right) =
\mbox{vec}\left(\mathbf{Y}\right) + \mathbf{\varepsilon} \; \mbox{ with }
\; \mathbf{\varepsilon} = \mbox{vec}\left(\mathbf{E}\right)}
or in transposed form:
\mjsdeqn{\mbox{vec}\left(\widehat{\mathbf{Y}}'\right) =
\mbox{vec}\left(\mathbf{Y}'\right) + \mathbf{\eta} \; \mbox{ with }
\; \mathbf{\eta} = \mbox{vec}\left(\mathbf{E}'\right).}
Denote with \mjseqn{\mathbf{P}} the \mjseqn{[n(k^\ast+m) \times n(k^\ast+m)]}
commutation matrix such that
\mjseqn{\mathbf{P}\mbox{vec}(\mathbf{Y}) = \mbox{vec}(\mathbf{Y}')},
\mjseqn{\mathbf{P}\mbox{vec}(\widehat{\mathbf{Y}}) = \mbox{vec}(\widehat{\mathbf{Y}}')}
and \mjseqn{\mathbf{P}\mathbf{\varepsilon} = {\bf \eta}}.
Let \mjseqn{\mathbf{W} = \mathrm{E}[\mathbf{\varepsilon\varepsilon}']} be the
covariance matrix of vector \mjseqn{\mathbf{\varepsilon}}, and
\mjseqn{\mathbf{\Omega} = \mathrm{E}[\mathbf{\eta\eta}']} the covariance matrix of
vector \mjseqn{\mathbf{\eta}}. Clearly, \mjseqn{\mathbf{W}} and
\mjseqn{\mathbf{\Omega}} are different parameterizations of the same
statistical object for which the following relationships hold:
\mjsdeqn{\mathbf{\Omega} = \mathbf{P}\mathbf{W}\mathbf{P}',
\qquad \mathbf{W} = \mathbf{P}' \mathbf{\Omega}\mathbf{P} .}
In order to apply the general point forecast reconciliation according to the
projection approach (\code{type = "M"}) to a cross-temporal forecast
reconciliation problem, we may consider either two \emph{vec}-forms , e.g.
if we follow the first:
\mjsdeqn{
\tilde{\mathbf{y}}= \hat{\mathbf{y}} - \mathbf{\Omega}\mathbf{H}\left(
\mathbf{H}'\mathbf{\Omega}\mathbf{H}\right)^{-1}\mathbf{H}'\hat{\mathbf{y}} =
{\mathbf{M}}\hat{\mathbf{y}},}
where \mjseqn{\widehat{\mathbf{y}} = \mbox{vec}(\widehat{\mathbf{Y}}')} is the
row vectorization of the base forecasts matrix \mjseqn{\widehat{\mathbf{Y}}}
The alternative equivalent solution (\code{type = "S"}) (following the
structural reconciliation approach by Hyndman et al., 2011) is
\mjsdeqn{\widetilde{\mathbf{y}} = \widetilde{\mathbf{S}}\left(\widetilde{\mathbf{S}}'
\mathbf{\Omega}^{-1}\widetilde{\mathbf{S}}\right)^{-1}\widetilde{\mathbf{S}}'
\mathbf{\Omega}^{-1}\widehat{\mathbf{y}} = \widetilde{\mathbf{S}}\mathbf{G}\widehat{\mathbf{y}}.}
where \mjseqn{\widetilde{\mathbf{S}}} is the cross-temporal summing matrix.

\strong{Bounds on the reconciled forecasts}

When the reconciliation uses the optimization package osqp,
the user may impose bounds on the reconciled forecasts.
The parameter \code{bounds} permits to consider lower (\mjseqn{\mathbf{a}}) and
upper (\mjseqn{\mathbf{b}}) bounds like \mjseqn{\mathbf{a} \leq
\widetilde{\mathbf{y}} \leq \mathbf{b}}, where \mjseqn{\widehat{\mathbf{y}} =
\mbox{vec}(\widehat{\mathbf{Y}}')}, such that:
\mjsdeqn{ \begin{array}{c}
a_1 \leq \widetilde{y}_1 \leq b_1 \cr
\dots \cr
a_{n(k^\ast + m)} \leq \widetilde{y}_{n(k^\ast + m)} \leq b_{n(k^\ast + m)} \cr
\end{array} \Rightarrow
\mbox{bounds} = [\mathbf{a} \; \mathbf{b}] =
\left[\begin{array}{cc}
a_1 & b_1 \cr
\vdots & \vdots \cr
a_{n(k^\ast + m)} & b_{n(k^\ast + m)} \cr
\end{array}\right],}
where \mjseqn{a_i \in [- \infty, + \infty]} and \mjseqn{b_i \in [- \infty, + \infty]}.
If \mjseqn{y_i} is unbounded, the i-th row of \code{bounds} would be equal
to \code{c(-Inf, +Inf)}.
Notice that if the \code{bounds} parameter is used, \code{sol = "osqp"} must be used.
This is not true in the case of non-negativity constraints:
\itemize{
  \item \code{sol = "direct"}: first the base forecasts
  are reconciled without non-negativity constraints, then, if negative reconciled
  values are present, the \code{"osqp"} solver is used;
  \item \code{sol = "osqp"}: the base forecasts are
  reconciled using the \code{"osqp"} solver.
}
In this case it is not necessary to build a matrix containing
the bounds, and it is sufficient to set \code{nn = "TRUE"}.

Non-negative reconciled forecasts may be obtained by setting \code{nn_type} alternatively as:
\itemize{
  \item \code{nn_type = "KAnn"} (Kourentzes and Athanasopoulos, 2021)
  \item \code{nn_type = "sntz"} ("set-negative-to-zero")
  \item \code{nn_type = "osqp"} (Stellato et al., 2020)
}
}
\examples{
data(FoReco_data)
obj <- octrec(FoReco_data$base, m = 12, C = FoReco_data$C,
              comb = "bdshr", res = FoReco_data$res)

}
\references{
Byron, R.P. (1978), The estimation of large social accounts matrices,
\emph{Journal of the Royal Statistical Society A}, 141, 3, 359-367.

Di Fonzo, T., Girolimetto, D. (2020), Cross-Temporal Forecast Reconciliation:
Optimal Combination Method and Heuristic Alternatives, Department of Statistical
Sciences, University of Padua, \href{https://arxiv.org/abs/2006.08570}{arXiv:2006.08570}.

\enc{Schäfer}{Schafer}, J.L., Opgen-Rhein, R., Zuber, V., Ahdesmaki, M.,
Duarte Silva, A.P., Strimmer, K. (2017), \emph{Package `corpcor'}, R
package version 1.6.9 (April 1, 2017), \href{https://CRAN.R-project.org/package=corpcor}{https://CRAN.R-project.org/package= corpcor}.

\enc{Schäfer}{Schafer}, J.L., Strimmer, K. (2005), A Shrinkage Approach to Large-Scale Covariance
Matrix Estimation and Implications for Functional Genomics, \emph{Statistical
Applications in Genetics and Molecular Biology}, 4, 1.

Stellato, B., Banjac, G., Goulart, P., Bemporad, A., Boyd, S. (2020). OSQP:
An Operator Splitting Solver for Quadratic Programs, \emph{Mathematical Programming Computation},
12, 4, 637-672.

Stellato, B., Banjac, G., Goulart, P., Boyd, S., Anderson, E. (2019), OSQP:
Quadratic Programming Solver using the `OSQP' Library, R package version 0.6.0.3
(October 10, 2019), \href{https://CRAN.R-project.org/package=osqp}{https://CRAN.R-project.org/package=osqp}.
}
\seealso{
Other reconciliation procedures: 
\code{\link{cstrec}()},
\code{\link{ctbu}()},
\code{\link{htsrec}()},
\code{\link{iterec}()},
\code{\link{lccrec}()},
\code{\link{tcsrec}()},
\code{\link{tdrec}()},
\code{\link{thfrec}()}
}
\concept{reconciliation procedures}
