% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fun_export.R
\name{unbalance_hierarchy}
\alias{unbalance_hierarchy}
\title{Aggregation matrix of a balanced hierarchy in (possibly) unbalanced form}
\usage{
unbalance_hierarchy(agg_mat, more_info = FALSE, sparse = TRUE)
}
\arguments{
\item{agg_mat}{A (\eqn{n_a \times n_b}) numeric matrix representing the cross-sectional
aggregation matrix. It maps the \eqn{n_b} bottom-level (free)
variables into the \eqn{n_a} upper (constrained) variables.}

\item{more_info}{If \code{TRUE}, it returns only the aggregation matrix
of the unbalanced hierarchy. \emph{Default} is \code{FALSE}.}

\item{sparse}{Option to return sparse matrices (\emph{default} is \code{TRUE}).}
}
\value{
A list containing four
elements (\code{more_info = TRUE}):
\item{ubm}{The aggregation matrix of the unbalanced hierarchy.}
\item{agg_mat}{The input matrix.}
\item{idrm}{The identification number of the duplicated variables (row numbers of
the aggregation matrix \code{agg_mat}).}
\item{id}{The identification number of each variable in the balanced hierarchy.
It may contains duplicated values.}
}
\description{
A hierarchy with \eqn{L} upper levels is said to be balanced if each variable at level
\eqn{l} has at least one child at level \eqn{l+1}. When this doesn't hold, the
hierarchy is unbalanced.
This function transforms an aggregation matrix of a balanced hierarchy
into an aggregation matrix of an unbalanced one, by removing possible duplicated series.
}
\examples{
#     Balanced     ->     Unbalanced
#        T                    T
#    |-------|            |-------|
#    A       B            A       |
#  |---|     |          |---|     |
# AA   AB    BA        AA   AB    BA
A <- matrix(c(1, 1, 1,
              1, 1, 0,
              0, 0, 1), 3, byrow = TRUE)
obj <- unbalance_hierarchy(agg_mat = A)
obj
}
\seealso{
Utilities: 
\code{\link{FoReco2matrix}()},
\code{\link{aggts}()},
\code{\link{balance_hierarchy}()},
\code{\link{commat}()},
\code{\link{csprojmat}()},
\code{\link{cstools}()},
\code{\link{ctprojmat}()},
\code{\link{cttools}()},
\code{\link{df2aggmat}()},
\code{\link{lcmat}()},
\code{\link{recoinfo}()},
\code{\link{res2matrix}()},
\code{\link{shrink_estim}()},
\code{\link{teprojmat}()},
\code{\link{tetools}()}
}
\concept{Utilities}
