% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/MatrixData

%Two new commands to help with formatting
\newcommand{\methodtable}{\bold{\cr #1 \cr} \tabular{lcl}}
\newcommand{\methoditem}{\emph{#1} \tab-\tab #2\cr}
\newcommand{\methodname}{\subsection{#1}}
\docType{class}
\name{MatrixData}
\alias{MatrixData}
\title{MatrixData}
\description{An abstract class for storing metaData relevant to a matrix. This class forms the backbone of the data structures.  It enforces the core functionality we want the data we model to have.  This class covers any data which has two major axes, and can be thought of as a matrix.  It also can cover the case where the data is matrix-like, but our representation of the data is not matrix-like.
##       TODO: make an example for this (think cholera data).}
\seealso{
Inherits from : \code{\link{DataContainer}}

Is inherited by : \code{\link{AbstractIncidenceMatrix}}, \code{\link{ArrayData}}}
\examples{
SampleMatrixData <- R6Class(
  inherit = MatrixData,
  public = list(
    initialize = function(data)\{
      if('matrix' \%in\% class(data))\{
        private$.mat = data
        private$.nrow = nrow(data)
        private$.ncol = ncol(data)
        private$.rnames = rownames(data)
        private$.cnames = colnames(data)
      \}
    \}
  )
)
}
\section{Fields}{
\describe{
\item{cellData}{A list of metadata associated with the cells of the data.}
\item{cnames}{The names of columns in the data.}
\item{colData}{A list of metadata associated with the columns of the data.}
\item{mat}{This is the matrix.  For extensibility, it cannot be written to directly and must be modified through methods.}
\item{metaData}{Any data not part of the main data structure.}
\item{ncol}{The number of columns in the data.}
\item{nrow}{The number of rows in the data}
\item{rnames}{The names of rows in the data.}
\item{rowData}{A list of metadata associated with the columns of the data.}
}}
\section{Methods}{
\methodname{debug(string)}{
A function for debugging the methods of this class.  It calls the \link{browser} command.  In order for methods to opt into to debugging, they need to implement the following code at the beginning: if(<method_name> \%in\% private$.debug)\{browser()\}.  This method exists, because the debugger is not always intuitive when it comes to debugging R6 methods.
\describe{\item{\emph{Arguments}}{\tabular{lcl}{
\methoditem{string}{The name(s) of methods to debug as a character vector}
}}}}
\methodname{initialize(...)}{
This function \bold{should} be extended. Create a new instance of this class.
\describe{\item{\emph{Arguments}}{\tabular{lcl}{
\methoditem{\dots}{This function should take in any arguments just in case.}
}}}}
\methodname{undebug(string)}{
A function for ceasing to debug methods.  Normally a method will call the \link{browser} command every time it is run.  This command will stop it from doing so.
\describe{\item{\emph{Arguments}}{\tabular{lcl}{
\methoditem{string}{The name(s) of the methods to stop debugging.}
}}}}
}
