% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/frechetpc.R
\name{Frechforest}
\alias{Frechforest}
\title{Frechet random forest}
\usage{
Frechforest(X, Y, id, time, mtry = ceiling(ncol(X)/3), ntree = 100,
  ncores = 1, ERT = FALSE, timeScale = 0.1, imp = TRUE, ...)
}
\arguments{
\item{X}{[matrix]: a data frame or a matrix of trajectories predictors. Each colunm codes for a trajectory predictor.}

\item{Y}{[vector]: a vector containing the output trajectories (same length as \code{nrow(X)}).}

\item{id}{[vector (factor)]: identifier, one for each trajectory to attribute each measurement of \code{X} and \code{Y} to one of the trajectories (same length as \code{Y}).}

\item{time}{[vector]: time measurements for the observations of both \code{X} and \code{Y} (same length as \code{Y}).}

\item{mtry}{[numeric]: number of variables randomly chosen at each split. Default is \code{ncol(X)/3}}

\item{ntree}{[numeric]: number of randomized Frechet trees composing the Frechet random forest. Default is 100.}

\item{ncores}{[numeric]: number of cores used in parallel. Default is 1.}

\item{ERT}{[logical]: if TRUE uses Extremly randomized Frechet trees to build the Frechet forest.}

\item{timeScale}{[numeric]: allow to modify the time scale, increasing or decreasing the cost of the horizontal shift. If timeScale is very big, then the Frechet mean tends to the Euclidean distance. If timeScale is very small, then it tends to the Dynamic Time Warping.}

\item{imp}{[logical]: TRUE to compute the variables importance FALSE otherwise (default \code{imp=}TRUE)}

\item{...}{: optional parameters to be passed to the low level function.}
}
\value{
a Frechet random forest which is a list of the following elements: \itemize{
\item \code{rf:} a list of the \code{ntree} randomized Frechet trees that compose the forest.
\item \code{mse :} a vector containing the OOB prediction error of each randomized Frechet tree composing the forest.
\item \code{OOB.err: } a vector containing the OOB prediction error of each trajectory in the learning sample.
\item \code{OOB.pred: } a list of the OOB prediction of each trajectory in the learning set.
\item \code{Importance: } A vector containing the \code{p} variables importance.
\item \code{rsq: } “pseudo R-squared”: \code{1 - mse/Var(y)}.
}
}
\description{
This function builds Frechet random Forest introduced by Capitaine et.al, this includes the OOB predictions, OOB errors and variable importance computations.
}
\examples{
\dontrun{
set.seed(10)
data <- DataGenCurves(50)
FRF <- Frechforest(data$X,data$Y, data$id,data$time, ntree=40,ncores=2, toPlot="none")
}
}
