% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/function-compare.R
\docType{methods}
\name{compareFuzzyNumbers}
\alias{compareFuzzyNumbers}
\alias{compareFuzzyNumbers,FuzzyData,character-method}
\title{Function to mutually compare fuzzy data}
\usage{
compareFuzzyNumbers(fuzzyData, type, progressBar = FALSE)

\S4method{compareFuzzyNumbers}{FuzzyData,character}(fuzzyData, type,
  progressBar = FALSE)
}
\arguments{
\item{fuzzyData}{A \code{\linkS4class{FuzzyData}}}

\item{type}{A \code{"character"} representing type of comparison. Currently implemented methods are
\code{"Chen"} and \code{"possibilityTheory"}.}

\item{progressBar}{logical value indicating if textual progress bar should be printed (default value \code{FALSE})}
}
\value{
A \code{"matrix"} of numeric value in case of \code{"Chen"} method or
a \code{"matrix"} with two values in case of \code{"possibilityTheory"}.
}
\description{
This function compares fuzzy data \code{\linkS4class{FuzzyData}} to identify the optimal (best) cases.
The \code{\linkS4class{FuzzyData}} can only contain one fuzzy number, otherwise the comparison is not possible.
The calculation of type \code{"possibilityTheory"} can be time consuming as it is based on comparing each fuzzy
number to a maximal fuzzy number obtained from the set of fuzzy numbers.
}
