% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ANFIS.R
\name{anfis.builder}
\alias{anfis.builder}
\title{ANFIS model builder}
\usage{
anfis.builder(fis)
}
\arguments{
\item{fis}{A fuzzy inference system model initialised by \code{\link{newfis}}.}
}
\value{
An ANFIS model
}
\description{
To build an ANFIS model from an existing FIS model
}
\examples{
fis <- anfis.tipper()
anfis <- anfis.builder(fis)
}
\references{
[1] C. Chen, R. John, J. Twycross, and J. M. Garibaldi, “An extended ANFIS architecture and its learning properties for type-1 and interval type-2 models,” in Proceedings IEEE International Conference on Fuzzy Systems, 2016, pp. 602–609. \cr
\doi{10.1109/FUZZ-IEEE.2016.7737742}

[2] C. Chen, R. John, J. Twycross, and J. M. Garibaldi, “Type-1 and interval type-2 ANFIS: a comparison,” in Proceedings IEEE International Conference on Fuzzy Systems, 2017, pp. 1–6.  \cr
\doi{10.1109/FUZZ-IEEE.2017.8015555}
}
\author{
Chao Chen
}
