% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Simulation_Spatialmod_Final_Model.R
\name{Simulation_Finalmodel}
\alias{Simulation_Finalmodel}
\title{This function can use to estimate the model parameters using the initial values.}
\usage{
Simulation_Finalmodel(
  ITER,
  zz,
  lambda0,
  sigma0,
  Di,
  g,
  nSample,
  d,
  n,
  time,
  tau,
  lambda,
  alpha0,
  beta10,
  beta20,
  cov1,
  cov2,
  phi,
  delta0,
  Nlabel,
  D,
  I
)
}
\arguments{
\item{ITER}{Number of iterations}

\item{zz}{Number of Regions}

\item{lambda0}{initial value for Spatial dependence}

\item{sigma0}{initial value for the precision of spatial random effects}

\item{Di}{Euclidean distance between susceptible individual and infectious individual}

\item{g}{Number of rows in the lattice}

\item{nSample}{Number of individuals in each cell}

\item{d}{infectious time units}

\item{n}{total number of individuals}

\item{time}{time}

\item{tau}{the set of infectious individuals at time t in the zth area}

\item{lambda}{a vector containing the length of infectious period}

\item{alpha0}{initial value for the intercept}

\item{beta10}{initial value for the parameter corresponding to the covariate associated with susceptible individual}

\item{beta20}{initial value for the parameter corresponding to the area-level covariates corresponding to area}

\item{cov1}{a vector of covariates associated with susceptible individual}

\item{cov2}{a vector of area-level covariates corresponding to area}

\item{phi}{Spatial random effects}

\item{delta0}{Spatial parameter}

\item{Nlabel}{Label for each sample from the area}

\item{D}{matrix reflecting neighborhood structure}

\item{I}{Identity matrix}
}
\value{
the estimated values for the model parameters
}
\description{
This function can use to estimate the model parameters using the initial values.
}
\examples{
Simulation_Finalmodel(2,4,0.2,0.5,
matrix(runif(1600,min=4,max=20),nrow=40,byrow=TRUE),2,10,3,40,10,
sample(c(0,1),replace=TRUE,size=40),rep(3,40),0.4,1,1,runif(40,0,1),
runif(4,0,1),runif(4,min=0,max=1),2,rep(1:4,each=10),
matrix(c(0,-1,0,-1,-1,0,-1,-1,0,-1,0,-1,-1,-1,-1,0),nrow=4,byrow=TRUE),
diag(4))


}
