% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/alpha.R
\name{attributepattern}
\alias{attributepattern}
\title{Generate all possible attribute patterns}
\usage{
attributepattern(K, poly = F, Q = NULL)
}
\arguments{
\item{K}{number of attributes}

\item{poly}{logical; is Q matrix polytomous?}

\item{Q}{Q-matrix; required when Q-matrix is polytomous}
}
\value{
attribute profiles for \eqn{2^K} latent classes
}
\description{
This function generates all possible attribute patterns.
The Q-matrix is needed when any attributes are polytomous.
}
\examples{
attributepattern(3)

q <- matrix(scan(text = "0 1 2 1 0 1 1 2 0"),ncol = 3)
q
attributepattern(ncol(q),poly=TRUE,q)

q <- matrix(scan(text = "0 1 1 1 0 1 1 1 0"),ncol = 3)
q
attributepattern(ncol(q),poly=TRUE,q)
}
\author{
{Wenchao Ma, Rutgers University, \email{wenchao.ma@rutgers.edu} \cr Jimmy de la Torre, The University of Hong Kong}
}
