% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/extract.R
\name{extract}
\alias{extract}
\title{extract elements from objects of various classes}
\usage{
extract(object, what, ...)
}
\arguments{
\item{object}{objects from class \code{GDINA},\code{itemfit}, \code{modelcomp}, \code{Qval} or \code{simGDINA}}

\item{what}{what to extract}

\item{...}{additional arguments}
}
\description{
A generic function to extract elements from objects of class \code{GDINA},
\code{itemfit}, \code{modelcomp}, \code{Qval} or \code{simGDINA}. This
page gives the elements that can be extracted from the class \code{GDINA}.
To see what can be extracted from \code{\link{itemfit}}, \code{\link{modelcomp}}, and
\code{\link{Qval}}, go to the corresponding function help page.

Objects which can be extracted from \code{GDINA} objects include:

\describe{
  \item{att.prior}{attribute prior weights for calculating marginalized likelihood in the last EM iteration}
  \item{discrim}{GDINA discrimination index}
  \item{designmatrix}{A list of design matrices for each item/category}
\item{expectedCorrect}{expected # of examinees in each latent group answering item correctly}
\item{expectedTotal}{expected # of examinees in each latent group}
\item{higher.order}{higher-order model specifications}
\item{linkfunc}{link functions for each item}
\item{initial.catprob}{initial item category probability parameters}
  \item{prevalence}{prevalence of each attribute}
  \item{posterior.prob}{posterior weights for each latent class}
}
}
\examples{
\dontrun{
dat <- sim10GDINA$simdat
Q <- sim10GDINA$simQ
fit <- GDINA(dat = dat, Q = Q, model = "GDINA")
extract(fit,"discrim")
extract(fit,"designmatrix")
}

}
