% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fboxplot.r
\name{fBoxplot}
\alias{fBoxplot}
\title{Functional boxplot}
\usage{
fBoxplot(curve_sets, factor = 1.5, ...)
}
\arguments{
\item{curve_sets}{A \code{curve_set} object or a list of \code{curve_set} objects.}

\item{factor}{The constant factor to inflate the central region to produce a functional boxplot and
determine fences for outliers. Default is 1.5 as in a classical boxplot.}

\item{...}{Additional parameters to be passed to \code{\link{central_region}},
which is responsible for calculating the central region (global envelope) on which
the functional boxplot is based.}
}
\description{
Functional boxplot based on central region computed by a specified measure.
The options of the measures can be found in \code{\link{central_region}}.
}
\examples{
if(requireNamespace("fda", quietly=TRUE)) {
  years <- paste(1:18)
  curves <- fda::growth[['hgtf']][years,]
  # Heights
  cset1 <- create_curve_set(list(r = as.numeric(years),
                                 obs = curves))
  bp <- fBoxplot(cset1, coverage=0.50, type="area", factor=1)
  plot(bp)

  # Considering simultaneously heights and height differences
  cset2 <- create_curve_set(list(r = as.numeric(years[-1]),
             obs = curves[-1,] - curves[-nrow(curves),]))
  csets <- list(Height=cset1, Change=cset2)
  res <- fBoxplot(csets, type='area', factor=1.5)
  plot(res) + ggplot2::labs(x="Age (years)", y="")
}
}
