% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/GE_bias_normal_squaredmis.R
\name{GE_bias_normal_squaredmis}
\alias{GE_bias_normal_squaredmis}
\title{GE_bias_normal_squaredmis.R}
\usage{
GE_bias_normal_squaredmis(beta_list, rho_list, prob_G, cov_Z = NULL,
  cov_W = NULL)
}
\arguments{
\item{beta_list}{A list of the effect sizes in the true model.
Use the order beta_0, beta_G, beta_E, beta_I, beta_Z, beta_M.
If Z or M is a vector, then beta_Z and beta_M should be vectors.}

\item{rho_list}{A list of the 6 pairwise covariances between the
covariates.  These should be in the order (1) cov_GE (2) cov_GZ (3) cov_EZ
(4) cov_GW (5) cov_EW (6) cov_ZW.
Again if Z or W are vectors then terms like cov_GZ should be vectors (in the order
cov(G,Z_1),...,cov(G,Z_p)) where Z is of dimension p, and similarly for W.
If Z or M are vectors, then cov_ZW should be a vector in the order (cov(Z_1,W_1),...,cov(Z_1,W_q),
cov(Z_2,W_1),........,cov(Z_p,W_q) where Z is a vector of length p and W is a vector of length q.}

\item{prob_G}{Probability that each allele is equal to 1.  Since each SNP has
two alleles, the expectation of G is 2*prob_G.}

\item{cov_Z}{Only used if Z is a vector, gives the covariance matrix of Z (remember by assumption
Z has mean 0 and variance 1).  The (i,j) element of the matrix should be the (i-1)(i-2)/2+j element
of the vector.}

\item{cov_W}{Only used if W is a vector, gives the covariance matrix of W (remember by assumption
W has mean 0 and variance 1).  The (i,j) element of the matrix should be the (i-1)(i-2)/2+j element
of the vector.}
}
\value{
A list with the elements:
\item{alpha_list}{The asymptotic values of the fitted coefficients alpha.}
\item{beta_list}{The same beta_list that was given as input.}
\item{cov_list}{The list of all covariances (both input and calculated) for use with GE_nleqslv() 
and GE_bias().}
\item{cov_mat_list}{List of additionally calculated covariance matrices for use with GE_nleqslv()
and GE_bias().}
\item{mu_list}{List of calculated means for f(E), h(E), Z, M, and W for use with GE_nleqslv() 
and GE_bias().}
\item{HOM_list}{List of calculated Higher Order Moments for use with GE_nleqslv() and GE_bias().}
}
\description{
A function to calculate the bias in testing for GxE interaction, making many more
assumptions than GE_bias().  The additional assumptions are added to simplify the process
of calculating/estimating many higher order moments which the user may not be familiar with. \cr
The following assumptions are made: \cr
(1) All fitted covariates besides G (that is, E, all Z, and all W) have a marginal standard 
normal distribution with mean 0 and variance 1.  This corresponds to the case of the researcher
standardizing all of their fitted covariates. \cr
(2) G is generated by means of thresholding two independent normal RVs and is centered to have mean 0.
(3) The joint distributions of E, Z, W, and the thresholded variables underlying G can be described
by a multivariate normal distribution. \cr
(4) The misspecification is of the form f(E)=h(E)=E^2, and M_j=W_j^2 for all j. In particular,
W always has the same length as M here. \cr
}
\examples{
GE_bias_normal_squaredmis( beta_list=as.list(runif(n=6, min=0, max=1)), 
						rho_list=as.list(rep(0.3,6)), prob_G=0.3)
}

