% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/visualizeComponents.R
\name{visualizeComponents}
\alias{visualizeComponents}
\title{Visualize GFA components}
\usage{
visualizeComponents(
  model,
  Y = NULL,
  norm = NULL,
  mode = 1,
  showAll = TRUE,
  hclust = FALSE,
  topK = 3,
  topFeatures = NA,
  topSamples = NA
)
}
\arguments{
\item{model}{The learned GFA model.}

\item{Y}{The used input data to be plotted, if supplied. Default NULL.}

\item{norm}{The normalization acquired from \code{\link{normalizeData}}, if
applied. If provided, the reconstruction is shown in the original data
space. Default NULL.}

\item{mode}{Determines which mode to visualize in case of pairing in two
modes (default: 1).}

\item{showAll}{Show the full predictions and factorizations? May be
cumbersome for large data. Default TRUE.}

\item{hclust}{Order features and samples based on hierarchical clustering?
Default FALSE.}

\item{topK}{Number of strongest components visualized in the data space.
Default 3.}

\item{topFeatures}{How many most relevant features to show for the data space
visualizations? Default NA, showing all the features.}

\item{topSamples}{How many most relevant samples to show for the data space
visualizations? Default NA, showing all the samples.}
}
\value{
A list containing the matrices that have been visualized.
}
\description{
\code{visualizeComponents} illustrates the factorization inferred by GFA,
averaging over the posteriors of the parameters, if they have been stored.
}
