% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ggm_compare.R
\name{compare_edges}
\alias{compare_edges}
\title{Compare Edges Between Gaussian Graphical Models}
\usage{
compare_edges(object_1, object_2, method = "fdr", alpha = 0.05, ...)
}
\arguments{
\item{object_1}{object of class \code{\link{ggmncv}} .}

\item{object_2}{An object of class \code{\link{ggmncv}}.}

\item{method}{Character string. A correction method for
multiple comparisons (defaults to \code{fdr}), which
can be abbreviated. See \link[stats]{p.adjust}.}

\item{alpha}{Numeric. Significance level (defaults to \code{0.05}).}

\item{...}{Currently ignored.}
}
\value{
\itemize{

\item \code{P_diff} De-sparsified partial correlation differences

\item \code{adj} Adjacency matrix based on the p-values.

\item \code{pval_uncorrected} Uncorrected p-values

\item \code{pval_corrected} Corrected p-values

\item \code{method} The approach used for multiple comparisons

\item \code{alpha} Significance level
}
}
\description{
Establish whether each of the corresponding edges
             are significantly different in two groups,
             with the de-sparsified estimator of \insertCite{jankova2015confidence}{GGMncv}.
}
\note{
For low-dimensional settings, i.e., when the number of observations
far exceeds the number of nodes, this function likely has limited utility and
a non regularized approach should be used for comparing edges
(see for example \strong{GGMnonreg}).

Further, whether the de-sparsified estimator provides nominal error rates
remains to be seen, at least across a range of conditions. For example,
the simulation results in \insertCite{williams_2021;textual}{GGMncv}
demonstrated that the confidence intervals
can have (severely) compromised coverage properties (whereas non-regularized methods
had coverage at the nominal level).
}
\examples{
# data
# note: all edges equal
Y1 <- MASS::mvrnorm(250, rep(0, 10), Sigma = diag(10))
Y2 <- MASS::mvrnorm(250, rep(0, 10), Sigma = diag(10))

# fit models
# note: atan penalty by default

# group 1
fit1 <- ggmncv(cor(Y1), n = nrow(Y1),
               progress = FALSE)

# group 2
fit2 <- ggmncv(cor(Y2), n = nrow(Y2),
               progress = FALSE)

# compare
compare_ggms <- compare_edges(fit1, fit2)

compare_ggms
}
\references{
\insertAllCited{}
}
