% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ggm_search.R
\name{ggm_search}
\alias{ggm_search}
\title{Gaussian graphical model: automated search}
\usage{
ggm_search(
  x,
  IC = "BIC",
  type = "neighborhood_selection",
  method = "forward",
  n = NULL
)
}
\arguments{
\item{x}{A data matrix of dimensions \emph{n} (observations) by \emph{p} (nodes) or
a correlation matrix of dimensions \emph{p} by \emph{p}.}

\item{IC}{Character string. The desired information criterion. Options include
\code{"AIC"} and \code{"BIC"} (default).}

\item{type}{Character string. Which search method should be used? The options included
\code{"regression"} and \code{"approx_L0"}. See details.}

\item{method}{Character string. The desired subset selection method
Options includes \code{"forward"} (default), \code{"backward"},
and \code{"exhaustive"}.}

\item{n}{Integer. Sample size. Required if a correlation matrix is provided.}
}
\value{
An object of class \code{ggm_search}, including \code{wadj} (weighted adjacency matrix)
        and \code{adj} (adjacency matrix).
}
\description{
Data mining to learn the graph.
}
\details{
\code{type = "neighborhood_selection"} was described in
\insertCite{williams2019nonregularized;textual}{GGMnonreg}
and \code{type = "approx_L0"} was described in \insertCite{williams2020beyond;textual}{GGMnonreg}.
The penalty for \code{type = "approx_L0"} is called seamless L0 \insertCite{dicker2013variable}{GGMnonreg}
}
\note{
\code{type = "neighborhood_selection"} employs multiple regression to estimate
the graph (requires the data), whereas \code{type = "approx_L0"} directly estimates
the precision matrix (data or a correlation matrix are acceptable). If
data is provided and \code{type = "approx_L0"}, by default Pearson correlations are
used. For another correlation coefficient, provide the desired correlation matrix.

\code{type = "approx_L0"} is a continuous approximation to (non-regularized)
best subset model selection. This is accomplished by using regularization, but
the penalty (approximately) mimics non-regularized estimation.
}
\examples{
\donttest{
# data
Y <- ptsd

# search data
fit <- ggm_search(Y)
}

}
\references{
\insertAllCited{}
}
