% file GLDreg/man/actg.Rd
\name{actg}
\alias{actg}
\title{ACTG 320 Clinical Trial Dataset}
\description{
actg dataset from Hosmer et al.
}
\usage{
data(actg)
}
\format{
\describe{
\item{id}{Identification Code}
\item{time}{Time to AIDS diagnosis or death (days).}
\item{censor}{Event indicator. 1 = AIDS defining diagnosis, 0 = Otherwise.}
\item{time_d}{Time to death (days)}
\item{censor_d}{Event indicator for death (only). 1 = Death, 0 = Otherwise.}
\item{tx}{Treatment indicator. 1 = Treatment includes IDV, 0 = Control group.}
\item{txgrp}{Treatment group indicator. 1 = ZDV + 3TC. 2 = ZDV + 3TC + IDV. 3 = d4T + 3TC.
4 = d4T + 3TC + IDV.}
\item{strat2}{CD4 stratum at screening. 0 = CD4 <= 50. 1 = CD4 > 50.}
\item{sexF}{0 = Male. 1 = Female.}
\item{raceth}{Race/Ethnicity. 1 = White Non-Hispanic. 2 = Black Non-Hispanic. 3 = Hispanic.
4 = Asian, Pacific Islander. 5 = American Indian, Alaskan Native. 6 = Other/unknown.}
\item{ivdrug}{IV drug use history. 1 = Never. 2 = Currently. 3 = Previously.}
\item{hemophil}{Hemophiliac. 1 = Yes. 0 = No.}
\item{karnof}{Karnofsky Performance Scale. 100 = Normal; no complaint no evidence of disease.
90 = Normal activity possible; minor signs/symptoms of disease. 80 = Normal activity with
effort; some signs/symptoms of disease. 70 = Cares for self; normal activity/active work not
possible.}
\item{cd4}{Baseline CD4 count (Cells/Milliliter).}
\item{priorzdv}{Months of prior ZDV use (months).}
\item{age}{Age at Enrollment (years).}
}
}
\source{
\url{https://hivdb.stanford.edu/pages/clinicalStudyData/ACTG320.html}
}

\references{
Hosmer, D.W. and Lemeshow, S. and May, S. (2008)
Applied Survival Analysis: Regression Modeling of Time to Event Data: Second
Edition, John Wiley and Sons Inc., New York, NY
}
\keyword{datasets}
