% Generated by roxygen2 (4.0.2): do not edit by hand
\name{dmvnormal}
\alias{dmvnormal}
\alias{rmvnormal}
\title{Multivariate Gaussian probability density function and simulation}
\usage{
dmvnormal(x, mu, sigma)

rmvnormal(n, mu, sigma)
}
\arguments{
\item{x}{A \code{p} times \code{k} matrix of quantiles. Each rows
correspond to a realization from the density and each column corresponds
to a dimension.}

\item{mu}{The mean vector of dimension \code{k}.}

\item{sigma}{The variance-covariance matrix of dimension \code{k} times
\code{k}.}

\item{n}{The number of observations to be simulated.}
}
\value{
\code{dmvnormal} returns a 1 by p matrix of the probability
  densities corresponding to each row of \code{x}.
\code{sigma}. Each row corresponds to an observation.

\code{rmvnormal} returns a \code{p} by \code{k} matrix of
  observations from a multivariate normal distribution with the given mean
  \code{mu} and covariance
}
\description{
Fast simulation and evalutation of multivariate Gaussian probability
densities.
}
\details{
\code{dmvnormal} functions similarly to \code{dmvnorm} from the
\code{mvtnorm}-package and likewise for \code{rmvnormal} and
\code{rmvnorm}.
}
\examples{
dmvnormal(x = matrix(rnorm(300), 100, 3),
          mu = 1:3,
          sigma = diag(3))
rmvnormal(n = 10, mu = 1:4, sigma = diag(4))
}
\author{
Anders Ellern Bilgrau
}
\seealso{
\code{dmvnorm} and \code{rmvnorm} in the \code{mvtnorm}-package.
}

