% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/compareGOspecies.R
\name{compareGOspecies}
\alias{compareGOspecies}
\title{Visual representation for the results of functional
 enrichment analysis to compare two species and a series of categories}
\usage{
compareGOspecies(
  df1,
  df2,
  GOterm_field,
  species1,
  species2,
  paired_lists = TRUE
)
}
\arguments{
\item{df1}{A data frame with the results of a functional enrichment analysis for the species 1
with an extra column "feature" with the features to be compared}

\item{df2}{A data frame with the results of a functional enrichment analysis for the species 2
with an extra column "feature" with the features to be compared}

\item{GOterm_field}{This is a string with the column name of the GO terms (e.g; "Functional_Category")}

\item{species1}{This is a string with the species name for species 1 (e.g; "H. sapiens")}

\item{species2}{This is a string with the species name for species 2 (e.g; "A. thaliana")}

\item{paired_lists}{This is a boolean to indicate if both species have same comparable categories (gene lists).
If the paired_lists is FALSE the counts will be done only for species and categories will be kept in
the outcomes. Please use carefully when paired_lists = FALSE.}
}
\value{
This function will return a list with four slots: graphics, distance shared_GO_list, and unique_GO_list
}
\description{
compareGOspecies function provides a simple workflow to compare results
 of functional enrichment analysis for two species.

 To use this function you will need two matrices with a column which, represents the features to be compared (e.g.feature).
 This function will extract the unique GO terms for two matrices and it will generate a presence-absence matrix
 where rows will represent a combination of categories and species (e.g H.sapiens AID) and columns will represent
 the GO terms analyzed. Further, this function  will calculate Jaccard distances and it will provide as outputs a list with four slots:
  1.) A principal coordinates analysis (PCoA)
  2.) The Jaccard distance matrix
  3.) A list of shared GO terms between species
  4.) Finally, a list of the unique GO terms and the belonging to the respective species.
}
\examples{

#Loading example datasets
data(H_sapiens_compress)
data(A_thaliana_compress)
#Defining the column with the GO terms to be compared
GOterm_field <- "Functional_Category"
#Defining the species names
species1 <- "H. sapiens"
species2 <- "A. thaliana"

#Running function
x <- compareGOspecies(df1=H_sapiens_compress,
                      df2=A_thaliana_compress,
                      GOterm_field=GOterm_field,
                      species1=species1,
                      species2=species2,
                      paired_lists=TRUE)

\dontrun{
#Displaying PCoA results
 x$graphics
# Checking shared GO terms between species
 print(tapply(x$shared_GO_list$feature,x$shared_GO_list$feature,length))
 }

}
