% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/normal_color_contour_grid.R
\name{normal.color.contour.grid}
\alias{normal.color.contour.grid}
\title{Draws the density of a grid copula with contours, normal marginals and colors}
\usage{
normal.color.contour.grid(
  gc,
  x1 = seq(-3, 3, length.out = 21),
  x2 = seq(-3, 3, length.out = 21),
  color.name = "gray",
  color.size = 7
)
}
\arguments{
\item{gc}{a grid type copula object.}

\item{x1}{indicates the place for lines on axis x1.}

\item{x2}{indicates the place for lines on axis x2.}

\item{color.name}{indicates the palette of colors.}

\item{color.size}{indicates the number of colors.}
}
\value{
Returns a graph.
}
\description{
Draws the density of a grid copula with contours, normal marginals and colors
}
\examples{
n <- 500
x <- rgamma(n,4,1/2)
e <- rnorm(n,0,.3)
y <- sin(x+e)
Fx <- ecdf(x)
Fy <- ecdf(y)
u <- Fx(x)
v <- Fy(y)
df <- cbind(u,v)
k <- 10
m <- 10
copula.grid <- estimate.gridCopula(U = df, k = k, m = m , method = "ml")
normal.color.contour.grid(gc = copula.grid, color.name = "heat.colors")
}
