% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/perspective_grid.R
\name{perspective.grid}
\alias{perspective.grid}
\title{Draws the density / distribution function of a grid copula with perspective}
\usage{
perspective.grid(
  gc,
  FUN = "d.grid",
  u1 = seq(0, 1, length.out = 21),
  u2 = seq(0, 1, length.out = 21),
  ang.theta = -30,
  ang.phi = 25,
  distancia = 10
)
}
\arguments{
\item{gc}{a grid type copula object.}

\item{FUN}{the name of the function to be applied (d.grid, p.grid), default is 'd.grid'.}

\item{u1}{indicates the place for lines on axis u1.}

\item{u2}{indicates the place for lines on axis u2.}

\item{ang.theta}{angle for the azimuthal direction.}

\item{ang.phi}{angle for the colatitude.}

\item{distancia}{the distance of the eyepoint from the centre of the box.}
}
\value{
Returns a graph of the density / distribution.
}
\description{
Draws the density / distribution function of a grid copula with perspective
}
\examples{
n <- 500
x <- rgamma(n,4,1/2)
e <- rnorm(n,0,.3)
y <- sin(x+e)
Fx <- ecdf(x)
Fy <- ecdf(y)
u <- Fx(x)
v <- Fy(y)
df <- cbind(u,v)
k <- 10
m <- 10
copula.grid <- estimate.gridCopula(U = df, k = k, m = m , method = "ml")
perspective.grid(gc = copula.grid, ang.theta = 90 , ang.phi = 80, distancia = 3)
perspective.grid(gc = copula.grid, FUN = "p.grid")
}
