% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/workbench.R
\name{createWorkbench}
\alias{createWorkbench}
\title{Workbench constructor}
\usage{
createWorkbench(
  folds = 10,
  reps = 5,
  stratified = FALSE,
  outfolder = NULL,
  outfile.name = "accuracy.csv",
  saveHyperParms = FALSE,
  saveExtraData = FALSE,
  regressor = phenoRegressor.rrBLUP,
  regressor.name = "default regressor",
  ...
)
}
\arguments{
\item{folds}{number of folds for crossvalidation, defaults to 10. If \code{NULL} no crossvalidation happens and
all training data will be used. In this case a second dataset, for test, is needed (see \link{GROAN.run}
for details)}

\item{reps}{number of times the whole test must be repeated, defaults to 5}

\item{stratified}{boolean indicating whether GROAN should take into account data strata. This have two
effects. First, the crossvalidation becomes stratified, meaning that folds will be
split so that training and test sets will contain the same proportions of each data stratum.
Second, prediction accuracy will be assessed (also) by strata.
If no strata are present in the \link[=createNoisyDataset]{GROAN.NoisyDataSet}
object and \code{stratified==TRUE} all samples will be considered belonging to the
same strata ("dummyStrata").
If \code{stratified} is FALSE (the default) GROAN will simply ignore the
strata, even if present in the \link[=createNoisyDataset]{GROAN.NoisyDataSet}.}

\item{outfolder}{folder where to save the data. If \code{NULL} (the default)
nothing will be saved. Filenames are standardized. If existing,
accuracy and hyperparameter files will be updated, otherwise are created. ExtraData
cannot be updated, so unique filenames will be generated using runId (see \link{GROAN.run})}

\item{outfile.name}{file name to be used to save the accuracies in a text file. Defaults to "accuracy.csv".
Ignored if \code{outfolder} is \code{NULL}}

\item{saveHyperParms}{boolean indicating if the hyperparameters from regressor training should be
saved in \code{outfolder}. Defaults to FALSE.}

\item{saveExtraData}{boolean indicating if extradata from regressor training should be
saved in \code{outfolder} as R objects (using the \link[base]{save} function). Defaults to FALSE.}

\item{regressor}{regressor function. Defaults to \code{\link{phenoRegressor.rrBLUP}}}

\item{regressor.name}{string that will be used in reports. Keep that in mind when deciding names. Defaults to "default regressor"}

\item{...}{extra parameter are passed to regressor function}
}
\value{
An instance of GROAN.Workbench
}
\description{
This function creates a GROAN.Workbench instance (or fails trying). The created object contains:\cr
a) one regressor with its own specific configuration\cr
b) the experiment parameters (number of repetitions, number of folds in case of crossvalidation, stratification...)\cr
You can have a general description of the created object using the overridden \link{print.GROAN.Workbench}
function.\cr
It is possible to add other regressors to the created \code{GROAN.Workbench} object using \link{addRegressor}.
Once the \code{GROAN.Workbench} is created it must be passed to \link{GROAN.run} to start the experiment.\cr
}
\examples{
#creating a Workbench with all default arguments
wb1 = createWorkbench()
#another Workbench, with different crossvalidation
wb2 = createWorkbench(folds=5, reps=20)
#a third one, with a different regressor and extra parameters passed to regressor function
wb3 = createWorkbench(regressor=phenoRegressor.BGLR, regressor.name='Bayesian Lasso', type='BL')
}
\seealso{
\link{addRegressor} \link{GROAN.run} \link{createNoisyDataset}
}
