# Generated by using Rcpp::compileAttributes() -> do not edit by hand
# Generator token: 10BE3573-1514-4C36-9D1C-5A225CD40393

#' lfisher_cpp
#'
#' @description Takes a four integers corresponding to a 2x2 contingency matrix and calculates a natural-log transformed
#' Fisher *p*-value.
#'
#' @param a (required) This corresponds to cell 1 of the contingency matrix. In the context of GSNA, assuming two gene
#' sets, this is used as the number of observable genes in the background that are not present either gene set.
#'
#' @param b (required) This corresponds to cell 2 of the contingency matrix. For GSNA this is the number of observable
#' genes present in gene set 1, but not gene set 2.
#'
#' @param c (required) This corresponds to cell 3 of the contingency matrix. For GSNA this is the number of observable
#' genes present in gene set 2, but not gene set 1.
#'
#' @param d (required) This corresponds to cell 4 of the contingency matrix. For GSNA this is the number of observable
#' genes present in both gene sets 1 and 2.
#'
#' @param e_precision (optional) Numeric value that determines the precision of summation of partial *p*-values. For
#' the less-than, greater-than and two-sided options in calculating the log-Fisher *p*-value, log-space summation of
#' partial *p*-values must be accomplished using the so-called *Log-Sum-Exponent* trick. Due to limitations of precision
#' in C++, however, numbers that differ by more than about 11 powers of *e* cannot be summed. By specifying a value less
#' than 12, slightly less precise p-values can be calculated slightly faster. This option was included as way to
#' accelerate calculation of *p*-values, but has not proven to significantly improve performance, so it may be removed
#' in the future. Defaults to 12.
#'
#' @param alternative (optional) Integer corresponding to 4 options:
#' \describe{
#'   \item{\code{1}}{single-sided, greater-than. Sums *p*-values for intersections greater than and equal to \code{d}.}
#'   \item{\code{2}}{single-sided, less-than. Sums *p*-values for intersections less than and equal to \code{d}.}
#'   \item{\code{3}}{two-sided, sums all partial *p*-values less than or equal to the partial *p*-value for intersections
#'      equal to \code{d}.}
#'   \item{\code{4}}{partial. Calculates single *p*-value for intersections equal to \code{d}.}
#'   }
#'
#' @return This function returns a numeric (double in C++) natural log-Fisher p-value.
#'
#' @export
#'
#' @details Calculation of Fisher *p*-values is discussed in detail elsewhere, but partial natural-log
#'  transformed *p*-values are calculated as follows:
#'
#'  Given a 2x2 contingency matrix of the form:
#'
#'  \deqn{\biggl[\begin{matrix}a & b \\ c & d\end{matrix}\biggr]}
#'
#' The natural log of the partial *p*-values is given by:
#'
#' \deqn{ln(p)  = ln((a+b)!) + ln((c+d)!) +
#'                ln((a+c)!) + ln((b+d)!) -
#'                ln(a!) - ln(b!) - ln(c!) -
#'                ln(d!) - ln((a + b + c + d)!)}
#'
#'
#' For the single and two-tailed alternatives, partial *p*-values are summed using the so-called 'log-sum-exponent' method.
#'
#' @examples
#'
#' library(GSNA)
#'
#' # Calculate a single natural log Fisher_p value:
#' log_fisher_p <- lfisher_cpp( a = 16000,
#'                              b = 200,
#'                              c = 170,
#'                              d = 100,
#'                              alternative = 3 )
#'
#'
#' @seealso
#'  \code{\link{gsIntersectCounts}}
#'  \code{\link{scoreLFMatrix_C}}
#'
lfisher_cpp <- function(a, b, c, d, e_precision = 12.0, alternative = 1L) {
    .Call(`_GSNA_lfisher_cpp`, a, b, c, d, e_precision, alternative)
}

#' scoreJaccardMatrix_C
#'
#' @description Takes a presence/absence matrix with genes as the rows and modules as columns and calculates
#' a matrix of Jaccard index values.
#'
#' @param geneSetCollection_m (required) A logical presence/absence matrix representation of a gene set collection
#' in which columns correspond to gene sets, rows correspond to genes and values are \code{TRUE} if a gene is present
#' in a gene set and \code{FALSE} otherwise. Row and column names correspond to gene symbols and gene set
#' identifiers, respectively. NOTE: for a typical GSNA analysis, this matrix would include only observed filtered
#' genes and significant gene set hits from pathways analysis. Using a matrix version of the full MSigDB without filtering
#' genes, for example, would likely be unworkably slow and memory intensive.
#'
#' @return This function returns a matrix of Jaccard index values between gene modules. Values on the diagonal
#' corresponding to self-Jaccard indices are returned as NA.
#'
#' @export
#'
#' @details The Jaccard index J for two sets A and B is defined as:
#'
#' \deqn{ J(A,B) = \dfrac{\lvert A \cap B \rvert}{\lvert A \cup B \rvert} }
#'
#'
#' @examples
#'
#' library(GSNA)
#'
#' # Get the background of observable genes set from
#' # expression data:
#' gene_background <- toupper(rownames( Bai_empty_expr_mat ))
#'
#' # Using the sample gene set collection **Bai_gsc.tmod**,
#' # generate a gene presence-absence matrix filtered for the
#' # ref.background of observable genes:
#' presence_absence.mat <-
#'  makeFilteredGenePresenceAbsenceMatrix( ref.background = gene_background,
#'                                         geneSetCollection = Bai_gsc.tmod )
#'
#' jaccard.mat <- scoreJaccardMatrix_C( presence_absence.mat )
#'
#' @seealso
#'  \code{\link{buildGeneSetNetworkJaccard}()}
#'  \code{\link{scoreLFMatrix_C}()}
#'
#'  @import Rcpp
#'
scoreJaccardMatrix_C <- function(geneSetCollection_m) {
    .Call(`_GSNA_scoreJaccardMatrix_C`, geneSetCollection_m)
}

#' scoreOCMatrix_C
#'
#' @description Takes a presence/absence matrix with genes as the rows and modules as columns and calculates
#' a matrix of overlap coefficient values (also known as Szymkiewicz–Simpson coefficients^1).
#'
#' @param geneSetCollection_m (required) A logical presence/absence matrix representation of a gene set collection
#' in which columns correspond to gene sets, rows correspond to genes and values are \code{TRUE} if a gene is present
#' in a gene set and \code{FALSE} otherwise. Row and column names correspond to gene symbols and gene set
#' identifiers, respectively. NOTE: for a typical GSNA analysis, this matrix would include only observed filtered
#' genes and significant gene set hits from pathways analysis. Using a matrix version of the full MSigDB without filtering
#' genes, for example, would likely be unworkably slow and memory intensive.
#'
#' @return This function returns a matrix of overlap coefficient values between gene modules. Values on the diagonal
#' corresponding to self-overlap coefficients are returned as NA.
#'
#' @export
#'
#' @details The overlap (or Szymkiewicz–Simpson) coefficient for two sets A and B is defined as:
#'
#' \deqn{ OC(A,B) = \dfrac{\lvert A \cap B \rvert}{min(\lvert A \rvert, \lvert B \rvert)} }
#'
#'
#' @examples
#'
#' library(GSNA)
#'
#' # Get the background of observable genes set from
#' # expression data:
#' gene_background <- toupper(rownames( Bai_empty_expr_mat ))
#'
#' # Using the sample gene set collection **Bai_gsc.tmod**,
#' # generate a gene presence-absence matrix filtered for the
#' # ref.background of observable genes:
#' presence_absence.mat <-
#'   makeFilteredGenePresenceAbsenceMatrix( ref.background = gene_background,
#'                                          geneSetCollection = Bai_gsc.tmod )
#'
#' # Now generate an overlap coefficient matrix.
#' oc.mat <- scoreOCMatrix_C( presence_absence.mat )
#'
#'
#' @seealso
#'  \code{\link{buildGeneSetNetworkOC}}
#'  \code{\link{scoreLFMatrix_C}}
#'
#' @references 1.  M.K V, K K. A Survey on Similarity Measures in Text Mining. MLAIJ. 2016;3: 19–28. doi:10.5121/mlaij.2016.3103
#'
#'  @import Rcpp
#'
scoreOCMatrix_C <- function(geneSetCollection_m) {
    .Call(`_GSNA_scoreOCMatrix_C`, geneSetCollection_m)
}

#' gsIntersect
#'
#' @description For two character vectors, returns the set of shared elements. This is used by GSNA to find shared genes
#' in two gene sets.
#'
#' @param gs1 A character vector representing gene symbols in a gene set.
#' @param gs2 A character vector representing gene symbols in a second gene set.
#'
#' @return A character vector consisting of the overlap of the two gene sets.
#'
#' @details This version of the function is used in gsnORAtest_cpp. (In another version of the function, used in
#' \code{gsnFilterGeneSetCollectionList()} and accessible only from C++ the first argument is gs1Set, a set of strings
#' of type \code{std::set<std::string>}.)
#'
#' This function does essentially what R's base::intersect does, so it is not necessarily useful to export.
#'
#' @examples
#'
#' library(GSNA)
#'
#' # We can extract 2 gene sets from the sample data:
#' Bai.gsc <- tmod2gsc( Bai_gsc.tmod )
#' M29994.gs = Bai.gsc[['M29994']]
#' M40825.gs = Bai.gsc[['M40825']]
#'
#' # Find the intersection:
#' intersect.gs <- gsIntersect( gs1 = M29994.gs, gs2 = M40825.gs )
#'
#' @export
#'
gsIntersect <- function(gs1, gs2) {
    .Call(`_GSNA_gsIntersect`, gs1, gs2)
}

#' gsIntersectCounts
#'
#' @description For two character vectors representing two gene sets (gs1 and gs2) and a total number of background
#' observable genes (that may also be present in gs1 and or gs2 or neither), this function calculates the counts in a
#' 2x2 contingency table for presence and absence of genes in one or both sets or neither. The output of this function
#' is used as the input for a Fisher test calculation by the GSNA package.
#'
#' @param gs1 A character vector representing gene symbols in a gene set.
#' @param gs2 A character vector representing gene symbols in a second gene set.
#' @param bg_size An integer representing the size of the background, i.e. the total number of observable genes.
#'
#' @return A numeric vector of length 4 containing the following 4 elements:
#' \itemize{
#'    \item{\code{a}: The number of genes in the background that are absent in gs1 and gs2.}
#'    \item{\code{b}: The number of background genes in gs1 but not gs2.}
#'    \item{\code{c}: The number of background genes in gs2 but not gs1.}
#'    \item{\code{d}: The number of background genes in in both gs1 and gs2.}
#'}
#' @details This version of the function may not be retained since it's not currently used. Two alternative versions of the
#' function in C++ that find the overlap between a \code{std::set<std::string>} and a character vector are used since those versions
#' are much faster.
#'
#' NOTE: This function assumes that all genes in gs1 and gs2 are present in the background, so to use this properly, gs1
#' and gs2 must be filtered to include only genes present in the background.
#'
#' @examples
#'
#' library( GSNA )
#'
#' # We can extract 2 gene sets from the sample data:
#' Bai.gsc <- tmod2gsc( Bai_gsc.tmod )
#' M29994.gs = Bai.gsc[['M29994']]
#' M40825.gs = Bai.gsc[['M40825']]
#'
#' # Get background gene cout:
#' bg_gene_count <- nrow( Bai_empty_expr_mat )
#'
#' # Generate a vector containing the number of contents of
#' # the 2x2 contingency table:
#' counts.v <- gsIntersectCounts( gs1 = M29994.gs,
#'                                gs2 = M40825.gs,
#'                                bg_size = bg_gene_count )
#'
#' @export
#'
gsIntersectCounts <- function(gs1, gs2, bg_size) {
    .Call(`_GSNA_gsIntersectCounts`, gs1, gs2, bg_size)
}

#' gsnFilterGeneSetCollectionList
#'
#' @description Given a vector of gene symbols and a gene set collection, filter the gene set collection to include
#' only gene symbols present in the background.
#'
#' @param bg A character vector representing gene symbols in a background of observable genes.
#'
#' @param geneSetCollection A list of gene sets, in which the gene sets are character vectors containing
#' gene symbols, and the list names are the corresponding gene set identifiers. NOTE: This must be a list, not a
#' \code{tmod} object. It is trivial to extract such a list from a \code{tmod} object, however. The
#' \code{$MODULES2GENES} field of the \code{tmod} object contains a suitable list.
#'
#' @return A filtered gene set as a list of vectors of gene symbols in which the list names correspond to gene
#' set IDs.
#'
#' @details This function is used in gsnORAtest_cpp to automatically filter the gene set provided. It may be used
#' manually during GSNA analysis.
#'
#' @examples
#'
#' library(GSNA)
#'
#' # Get the background of observable genes set from
#' # expression data:
#' gene_background <- toupper(rownames( Bai_empty_expr_mat ))
#'
#' # Generate a gene set collection as a list of vectors from
#' # **Bai_gsc.tmod**, included in sample data:
#' Bai.gsc <- tmod2gsc( Bai_gsc.tmod )
#'
#' # Using the sample gene set collection **Bai_gsc.tmod**,
#' # generate a gene set collection filtered for the bg of
#' # observable genes:
#' Bai.filt.gsc <- gsnFilterGeneSetCollectionList( bg = gene_background,
#'                                          geneSetCollection = Bai.gsc )
#'
#' @export
#'
gsnFilterGeneSetCollectionList <- function(bg, geneSetCollection) {
    .Call(`_GSNA_gsnFilterGeneSetCollectionList`, bg, geneSetCollection)
}

#' gsnORAtest_cpp
#'
#' @description This function performs ORA analysis and returns a data.frame containing various statistics including
#' fold enrichment, and 1 and 2-tailed p-values. (see details)
#'
#' @param l (required) A character vector containing a list of gene identifiers. These are generally differentially
#' expressed genes either genes significantly up or significantly down, but they can also be a list of genes that came
#' out of a genetic screen, gene loci with differential chromatin accessibility generated by ATAC-Seq data, lists of genes
#' from GWAS, etc. The order of the genes is unimportant.
#'
#' @param bg (required) A character vector containing a list of gene identifiers corresponding to the total background of
#' observable genes.
#'
#' @param geneSetCollection (required) A list of gene sets, in which the gene sets are character vectors containing
#' gene symbols, and the list names are the corresponding gene set identifiers. NOTE: This must be a list, not a
#' \code{tmod} object. It is trivial to extract such a list from a \code{tmod} object, however. The
#' \code{$MODULES2GENES} field of the \code{tmod} object contains a suitable list.
#'
#' @return A data frame containing the results of overrepresentation analysis.
#' \itemize{
#'   \item{*ID*: the gene set identifiers.}
#'   \item{*a*: the number of genes observed in the background but not in *l* or the queried gene set.}
#'   \item{*b*: the number of observed genes in *l* but not the queried gene set.}
#'   \item{*c*: the number of observed genes in the queried gene set but not *l* and}
#'   \item{*d*: the number of observed genes in both *l* and the queried gene set, i.e. the overlap.}
#'   \item{*N*: the number of observed genes the queried gene set.}
#'   \item{*Enrichment*: The fold overrepresentation of genes in the overlap set *d* calculated as:
#'       \deqn{E = (d / (c+d)) / ((b+d)/(a+b+c+d))}
#'        }
#'   \item{*P_2S*: 2-sided Fisher *p*-value. (*NOT* log-transformed.)}
#'   \item{*P_1S*: 1-sided Fisher *p*-value. (*NOT* log-transformed.)}
#' }
#'
#' @details This is the main workhorse function for the ORA test in the \code{GSNA} package, however, it performs
#' no filtering of the output data set, nor *p*-value adjustment, and most users of the package will want to use
#' \code{gsnORAtest()} function instead, which calculates adjusted *p*-values, filters the output data for
#' significance, and can include a \code{Title} field in the output data.frame.
#'
#' @seealso \code{\link{gsnORAtest}}
#'
#' @examples
#'
#' library(GSNA)
#'
#' # From a differential expression data set, we can generate a
#' # subset of genes with significant differential expression,
#' # up or down. Here we will extract genes with significant
#' # negative differential expression with
#' # avg_log2FC < 0 and p_val_adj <= 0.05 from **Seurat** data:
#'
#' sig_DN.genes <-
#'    toupper( rownames(subset( Bai_CiHep_v_Fib2.de,
#'                       avg_log2FC < 0  & p_val_adj < 0.05 )) )
#'
#' # Using all the genes in the differential expression data set,
#' # we can obtain a suitable background:
#' bg <- rownames( Bai_CiHep_v_Fib2.de )
#'
#' # Next we need a gene set collection in the form of a list of
#' # character vectors. We can convert the **Bai_gsc.tmod** object
#' # included in the sample data to such a list:
#' Bai.gsc <- tmod2gsc( Bai_gsc.tmod )
#'
#' # Now, we can do a overrepresentation analysis search on this
#' # data using **Bai.gsc**:
#' sig_DN.gsnora <- gsnORAtest_cpp( l = sig_DN.genes,
#'                                  bg = bg,
#'                                  geneSetCollection = Bai.gsc )
#'
#' @export
#'
#'
gsnORAtest_cpp <- function(l, bg, geneSetCollection) {
    .Call(`_GSNA_gsnORAtest_cpp`, l, bg, geneSetCollection)
}

#' scoreLFMatrix_C
#'
#' @description Takes a presence/absence matrix with genes as the rows and modules as columns and calculates
#' a matrix of log-transformed Fisher *p*-values.
#'
#' @usage
#'  scoreLFMatrix_C( geneSetCollection_m,
#'                   e_precision = as.numeric(c(12)),
#'                   alternative = as.integer(c(1)))
#'
#' # # NOTE: The following also works and may be preferable for
#' # # many users:
#' # scoreLFMatrix_C( geneSetCollection_m,
#' #                  e_precision = 12,
#' #                  alternative = 1 )
#'
#' @param geneSetCollection_m (required) A logical presence/absence matrix representation of a gene set collection
#' in which columns correspond to gene sets, rows correspond to genes and values are \code{TRUE} if a gene is present
#' in a gene set and \code{FALSE} otherwise. Row and column names correspond to gene symbols and gene set
#' identifiers, respectively. NOTE: for a typical GSNA analysis, this matrix would include only observed filtered
#' genes and significant gene set hits from pathways analysis. Using a matrix version of the full MSigDB without filtering
#' genes, for example, would likely be unworkably slow and memory intensive.
#'
#' @param e_precision (optional, default 12) Numeric to control the precision of the log p-value calculated.
#' Due to precision limits inherent in C++ double precision numbers, log p-values for which the corresponding
#' untransformed p-values differ by more than a certain magnitude cannot effectively be added. This feature
#' was introduced as a way to accelerate summation of p-values so as to allow summation to be cut off
#' when the acceptable level of precision had been reached, but it was found that it also seems to prevent
#' artifacts caused by arithmetic underflow.
#'
#' @param alternative (optional, default 1) An integer value specifying one of 4 alternative p-value calculations
#' where \code{1} specifies single, upper tail log Fisher p-value, \code{2} signifies single, lower-tail Fisher
#' p-value, \code{3} signifies 2-tailed Fisher p-value, and \code{4} signifies partial Fisher p-value (see below).
#'
#' @return A numerical matrix containing the specified log Fisher *p*-values for all non-self pairs. Values on the
#' diagonal (which would correspond to self-self comparison *p*-values) are NA. The \code{'lower_is_closer'}
#' attribute on the matrix is set to \code{TRUE}, except in the case of \code{alternative=2} where it is set
#' to \code{FALSE}.
#'
#' The \code{distance} attribute in the output matrix is set to \code{'stlf'} for option 1 (single, upper tail),
#' \code{'ltlf'} for option 2 (lower tail), \code{'ttlf'} for option 3 (two-tailed), and \code{'lf'} for option 4
#' (log partial Fisher *p*-value).
#'
#' @export
#'
#' @details
#'
#' Fisher *p*-values have long been used to assess the statistical significance of over- or underrepresentation
#' of a component of a mixture to assess whether a sample is drawn from a particular mixture. The test has also
#' long been used in pathways analysis as a way to assess whether an experimentally derived list of genes
#' contains a statistical overrepresentation of genes from predefined gene sets or modules. Such experimental gene
#' lists may include differentially expressed genes from a transcriptomic experiment, genes possessing promoters
#' with differential chromatin accessibility from an ATAC-Seq experiments, genes that were positive in screens of
#' mutants, genes that were identified from GWAS experiments, and genes from other analyses. Likewise, the gene
#' sets or modules are generally drawn from databases of experimentally characterized pathways, sets of genes
#' over- or under-expressed in particular conditions, or associated with particular biological processes,
#' chromosome regions, etc.
#'
#' In the case of GSNA, we use the Fisher test to assess the overlap of genes not between an experimentally
#' derived gene list and predefined gene sets from a database, but between the predefined gene sets themselves
#' given their observability in a particular experiment.
#'
#' # Implementation
#'
#' We use the Fisher test to assess the statistical significance of the overlap of two gene sets. For our purposes
#' the test determines whether two gene sets share a greater (or in some cases less) than expected number of common
#' members, assuming a null hypothesis of random membership. The two sets need not necessarily be of the same size,
#' but are for the purposes of the test assumed to have set sizes.
#'
#' Consider a 2x2 contingency matrix of the following form:
#'
#'  \deqn{\biggl[\begin{matrix}a & b \\ c & d\end{matrix}\biggr]}
#'
#' Given a background of observable genes and two gene sets, *i* and *j* that may overlap, this contingency
#' table is used to represent four numbers:
#'
#' \itemize{
#'   \item{*a*: the number of genes observed in the background but not in *i* or *j*}
#'   \item{*b*: the number of observed genes in *i* but not *j*}
#'   \item{*c*: the number of observed genes in *j* but not *i* and}
#'   \item{*d*: the number of observed genes in both *j* and *i*, i.e. the overlap.}
#' }
#'
#' The *partial*-Fisher *p*-value, signifying the likelihood of that particular contingency
#' table is given by:
#'
#' \deqn{p = \dfrac{(a + b)! (c + d)! (a + c)! (b + d)!}{a! b! c! d! (a+b+c+d)!}}
#'
#' This partial *p*-value is what is returned in the distance matrix when the argument \code{alternative = 4}
#' and it is less than, though tracks closely with, the two-tailed p-value, in most cases.
#'
#' The actual single- and two-tailed *p*-values are derived from this number by summation, keeping the sum of
#' each row and column of the 2x2 contingency matrix constant, as per the assumptions of the Fisher test.
#' For the single-tailed alternative representing the upper-tail 'greater-than' expected overlap of the two gene
#' sets (\code{alternative = 1}), the terms start with *d* as the observed number of shared members between set
#' *i* and set *j*. Then *d* is incremented toward the maximal number possible shared genes (the lesser of the
#' number of genes in sets *i* and *j*). *a*, *b*, and *c* adjusted accordingly to keep constant row and
#' column sums, and the partial *p*-values are thus summed.
#'
#' For the lower-tail ('less-than') alternative (\code{alternative = 2}), the summation starts with *d* as the
#' number of shared members of sets between *i* and *j*, (as with the upper-tail calculation) but then decrements
#' that to 0.
#'
#' For the 2-tailed alternative, the function sums all the terms with values equal to or less than the the
#' partial *p*-value defined above.
#'
#' All calculations are done on log-transformed values to avoid arithmetic underflow:
#'
#'\deqn{
#'  ln(p) = ln(( a + b )!) + ln(( c + d )!) +
#'          ln(( a + c )!) + ln(( b + d )!) -
#'          ln(a!) - ln(b!) - ln(c!) - ln(d!) -
#'          ln(( a + b + c + d )!)
#'}
#'
#' Since log-transformed *p*-values cannot be directly added, the so-called log-sum-exponential trick is used to
#' combine them.
#'
#'
#' @examples
#'
#' library( GSNA )
#'
#' # Get the background of observable genes set from
#' # expression data:
#' gene_background <- toupper(rownames( Bai_empty_expr_mat ))
#'
#' # Using the sample gene set collection **Bai_gsc.tmod**,
#' # generate a gene presence-absence matrix filtered for the
#' # ref.background of observable genes:
#' presence_absence.mat <-
#'   makeFilteredGenePresenceAbsenceMatrix( ref.background = gene_background,
#'                                          geneSetCollection = Bai_gsc.tmod )
#'
#' lf.mat <- scoreLFMatrix_C( presence_absence.mat,  1 )
#'
#' @seealso
#'  \code{\link{buildGeneSetNetworkLFFast}}
#'  \code{\link{scoreJaccardMatrix_C}}
#'
scoreLFMatrix_C <- function(geneSetCollection_m, e_precision = as.numeric( c(12)), alternative = as.integer( c( 1 ))) {
    .Call(`_GSNA_scoreLFMatrix_C`, geneSetCollection_m, e_precision, alternative)
}

