\encoding{UTF-8}

\name{GUTS-package}
\alias{GUTS-package}
%\alias{attr<-}
\alias{attr<-.GUTS}
%\alias{attributes<-}
\alias{attributes<-.GUTS}
%\alias{mostattributes<-}
\alias{mostattributes<-.GUTS}
\alias{print.GUTS}
\alias{modguts}
\alias{[[<-.GUTS}
\alias{$<-.GUTS}

\docType{package}

\title{Fast Calculation of the Likelihood of a Stochastic Survival Model}

\description{GUTS (General Unified Threshold model of Survival) is a stochastic survival model for ecotoxicology.  The package allows for the definition of exposure and survival time series as well as parameter values, and the fast calculation of the survival probabilities as well as the logarithm of the corresponding likelihood.}

\details{
\tabular{ll}{
Package: \tab GUTS\cr
Type: \tab Package\cr
%Version: \tab 1.0\cr
%Date: \tab 2015-05-03\cr
License: \tab GPL (>= 2)\cr
}
A GUTS object is a special list of class \dQuote{GUTS}.  Functions \code{\link{guts_setup}}, \code{\link{guts_calc_loglikelihood}} and \code{\link{guts_calc_survivalprobs}} are available to create and work with GUTS objects.  A data set \link{diazinon} is also included.  See links for more details.
}

\author{Carlo Albert \email{carlo.albert@eawag.ch} and Sören Vogel \email{soeren.vogel@posteo.ch}

Maintainer: Sören Vogel \email{soeren.vogel@posteo.ch}}

\references{Jager, T., Albert, C., Preuss T. and Ashauer R. (2011) General unified threshold model of survival -- a toxicokinetic toxicodynamic framework for ecotoxicology. Environmental Science \& Technology, 45(7), 2529--2540, doi: 10.1021/es103092a.}

\seealso{\code{\link{guts_setup}}, \code{\link{guts_calc_loglikelihood}}, \code{\link{guts_calc_survivalprobs}}, \code{\link{diazinon}}, \code{\link{Rcpp}}}
