\name{getCOEF}
\alias{getCOEF}

\title{Return country-specific standard LS coefficient estimates.
}

\encoding{latin1}

\description{Extract country-specific standard LS coefficient estimates.
}
\usage{getCOEF(out,sheet)
}

\arguments{
  \item{out}{A list object of estimation results generated by GVARest()
}
  \item{sheet}{The number of country in out file
}

}
\details{Extract country-specific standard LS coefficient estimates.
}

\value{
  \item{coef}{Country-specific coefficient estimates}

}


\author{Ho Tsung-wu <tsungwu@ntnu.edu.tw>, College of Management, National Taiwan Normal University.
}

\examples{
data("PriceVol")
data("tradeweight1")
data("tradeweightx")
p=2
FLag=2
lag.max=15
type="const"
ic="SC"
weight.matrix=tradeweightx
mainOUTPUT = GVARest(data=PriceVol,p,FLag,lag.max,type,ic,weight.matrix)
COEF=getCOEF(out=mainOUTPUT,sheet=1)

}
