% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gwalkr.R
\name{gwalkr-shiny}
\alias{gwalkr-shiny}
\alias{gwalkrOutput}
\alias{renderGwalkr}
\title{Shiny bindings for gwalkr}
\usage{
gwalkrOutput(outputId, width = "100\%", height = "100\%")

renderGwalkr(expr, env = parent.frame(), quoted = FALSE)
}
\arguments{
\item{outputId}{output variable to read from}

\item{width, height}{Must be a valid CSS unit (like \code{'100\%'},
\code{'400px'}, \code{'auto'}) or a number, which will be coerced to a
string and have \code{'px'} appended.}

\item{expr}{An expression that generates a gwalkr}

\item{env}{The environment in which to evaluate \code{expr}.}

\item{quoted}{Is \code{expr} a quoted expression (with \code{quote()})? This
is useful if you want to save an expression in a variable.}
}
\value{
\itemize{
\item \code{gwalkrOutput}: A \code{shinyWidgetOutput} object for the root HTML element.
\item \code{renderGwalkr}: A server-side function to help Shiny display the GWalkR visualization.
}
}
\description{
Output and render functions for using gwalkr within Shiny
applications and interactive Rmd documents.
}
\examples{
# !formatR
library(GWalkR)
library(shiny)
data(mtcars)
app <- shinyApp(
  ui = fluidPage(
    titlePanel("Explore the data here: "),
    gwalkrOutput("mygraph")
  ),
  server = function(input, output, session) {
    output$mygraph = renderGwalkr(
      gwalkr(mtcars)
    )
  }
)
\donttest{if (interactive()) app}
}
