% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/compiled_code_gamabiomd.R
\name{write_fasta}
\alias{write_fasta}
\title{Writes a data frame to a FASTA file.}
\usage{
write_fasta(data)
}
\arguments{
\item{data}{A data frame with 'SequenceID' and 'Sequence' columns.}
}
\value{
A character vector representing the contents of the FASTA file.
}
\description{
This function takes a data frame with 'SequenceID' and 'Sequence' columns
and writes the contents to a FASTA file. Each row in the data frame corresponds
to a sequence in the FASTA file, with the 'SequenceID' used as the header line
and the 'Sequence' as the sequence line.
}
\examples{
\donttest{
accession_ranges <- list(
  SRU1 = "AJ240966 to AJ240970",
  STU2 = "AB015240 to AB015245",
  WPU13 = "L11934 to L11939",
  INU20 = c("AF277467 to AF277470", "AF333080 to AF333085")
)

# Use the function to expand accession ranges
sam_acc <- expand_accession_ranges(accession_ranges)
print(sam_acc)

# 2 get_sequence_information
accessions_to_query <- sam_acc$accession
seq_info <- get_sequence_information(accessions_to_query, remove_dot_1 = TRUE)
print(seq_info)
result <- preprocess_for_alignment(sam_acc, seq_info)

# Access the resulting data frames
merged_data <- result$merged_data
main_data <- result$main_data
final_data <- result$final_data

data <- final_data

# Call the function
fasta_content <- write_fasta(data)

# Print or use the `fasta_content` as needed
print(fasta_content)

output_directory <- tempdir()
# Specify the output file path
output_file_path <- file.path(output_directory, "output.fasta")

# Open a connection to the output file
output_file <- file(output_file_path, "w")

# Write the content to the file
writeLines(fasta_content, output_file)

# Close the output file
close(output_file)

# Print a message indicating successful file creation
warning("FASTA file has been created and saved at:", output_file_path, "\n")
}
}
