% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/kernel_model_LOO.R
\docType{class}
\name{GauPro_kernel_model_LOO}
\alias{GauPro_kernel_model_LOO}
\title{Corr Gauss GP using inherited optim}
\format{
\code{\link{R6Class}} object.
}
\value{
Object of \code{\link{R6Class}} with methods for fitting GP model.
}
\description{
Corr Gauss GP using inherited optim

Corr Gauss GP using inherited optim
}
\examples{
n <- 12
x <- matrix(seq(0,1,length.out = n), ncol=1)
y <- sin(2*pi*x) + rnorm(n,0,1e-1)
gp <- GauPro_kernel_model_LOO$new(X=x, Z=y, kernel=Gaussian)
y <- x^2 * sin(2*pi*x) + rnorm(n,0,1e-3)
gp <- GauPro_kernel_model_LOO$new(X=x, Z=y, kernel=Matern52)
y <- exp(-1.4*x)*cos(7*pi*x/2)
gp <- GauPro_kernel_model_LOO$new(X=x, Z=y, kernel=Matern52)
}
\section{Super class}{
\code{\link[GauPro:GauPro]{GauPro::GauPro}} -> \code{GauPro_kernel_model_LOO}
}
\section{Public fields}{
\if{html}{\out{<div class="r6-fields">}}
\describe{
\item{\code{tmod}}{A second GP model for the t-values of leave-one-out predictions}

\item{\code{use_LOO}}{Should the leave-one-out error corrections be used?}
}
\if{html}{\out{</div>}}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-GauPro_kernel_model_LOO-new}{\code{GauPro_kernel_model_LOO$new()}}
\item \href{#method-GauPro_kernel_model_LOO-update}{\code{GauPro_kernel_model_LOO$update()}}
\item \href{#method-GauPro_kernel_model_LOO-pred_one_matrix}{\code{GauPro_kernel_model_LOO$pred_one_matrix()}}
\item \href{#method-GauPro_kernel_model_LOO-clone}{\code{GauPro_kernel_model_LOO$clone()}}
}
}
\if{html}{\out{
<details><summary>Inherited methods</summary>
<ul>
<li><span class="pkg-link" data-pkg="GauPro" data-topic="GauPro" data-id="EI"><a href='../../GauPro/html/GauPro.html#method-GauPro-EI'><code>GauPro::GauPro$EI()</code></a></span></li>
<li><span class="pkg-link" data-pkg="GauPro" data-topic="GauPro" data-id="KG"><a href='../../GauPro/html/GauPro.html#method-GauPro-KG'><code>GauPro::GauPro$KG()</code></a></span></li>
<li><span class="pkg-link" data-pkg="GauPro" data-topic="GauPro" data-id="cool1Dplot"><a href='../../GauPro/html/GauPro.html#method-GauPro-cool1Dplot'><code>GauPro::GauPro$cool1Dplot()</code></a></span></li>
<li><span class="pkg-link" data-pkg="GauPro" data-topic="GauPro" data-id="deviance"><a href='../../GauPro/html/GauPro.html#method-GauPro-deviance'><code>GauPro::GauPro$deviance()</code></a></span></li>
<li><span class="pkg-link" data-pkg="GauPro" data-topic="GauPro" data-id="deviance_fngr"><a href='../../GauPro/html/GauPro.html#method-GauPro-deviance_fngr'><code>GauPro::GauPro$deviance_fngr()</code></a></span></li>
<li><span class="pkg-link" data-pkg="GauPro" data-topic="GauPro" data-id="deviance_grad"><a href='../../GauPro/html/GauPro.html#method-GauPro-deviance_grad'><code>GauPro::GauPro$deviance_grad()</code></a></span></li>
<li><span class="pkg-link" data-pkg="GauPro" data-topic="GauPro" data-id="fit"><a href='../../GauPro/html/GauPro.html#method-GauPro-fit'><code>GauPro::GauPro$fit()</code></a></span></li>
<li><span class="pkg-link" data-pkg="GauPro" data-topic="GauPro" data-id="get_optim_functions"><a href='../../GauPro/html/GauPro.html#method-GauPro-get_optim_functions'><code>GauPro::GauPro$get_optim_functions()</code></a></span></li>
<li><span class="pkg-link" data-pkg="GauPro" data-topic="GauPro" data-id="grad"><a href='../../GauPro/html/GauPro.html#method-GauPro-grad'><code>GauPro::GauPro$grad()</code></a></span></li>
<li><span class="pkg-link" data-pkg="GauPro" data-topic="GauPro" data-id="grad_dist"><a href='../../GauPro/html/GauPro.html#method-GauPro-grad_dist'><code>GauPro::GauPro$grad_dist()</code></a></span></li>
<li><span class="pkg-link" data-pkg="GauPro" data-topic="GauPro" data-id="grad_norm"><a href='../../GauPro/html/GauPro.html#method-GauPro-grad_norm'><code>GauPro::GauPro$grad_norm()</code></a></span></li>
<li><span class="pkg-link" data-pkg="GauPro" data-topic="GauPro" data-id="grad_norm2_dist"><a href='../../GauPro/html/GauPro.html#method-GauPro-grad_norm2_dist'><code>GauPro::GauPro$grad_norm2_dist()</code></a></span></li>
<li><span class="pkg-link" data-pkg="GauPro" data-topic="GauPro" data-id="grad_norm2_mean"><a href='../../GauPro/html/GauPro.html#method-GauPro-grad_norm2_mean'><code>GauPro::GauPro$grad_norm2_mean()</code></a></span></li>
<li><span class="pkg-link" data-pkg="GauPro" data-topic="GauPro" data-id="grad_norm2_sample"><a href='../../GauPro/html/GauPro.html#method-GauPro-grad_norm2_sample'><code>GauPro::GauPro$grad_norm2_sample()</code></a></span></li>
<li><span class="pkg-link" data-pkg="GauPro" data-topic="GauPro" data-id="grad_sample"><a href='../../GauPro/html/GauPro.html#method-GauPro-grad_sample'><code>GauPro::GauPro$grad_sample()</code></a></span></li>
<li><span class="pkg-link" data-pkg="GauPro" data-topic="GauPro" data-id="hessian"><a href='../../GauPro/html/GauPro.html#method-GauPro-hessian'><code>GauPro::GauPro$hessian()</code></a></span></li>
<li><span class="pkg-link" data-pkg="GauPro" data-topic="GauPro" data-id="importance"><a href='../../GauPro/html/GauPro.html#method-GauPro-importance'><code>GauPro::GauPro$importance()</code></a></span></li>
<li><span class="pkg-link" data-pkg="GauPro" data-topic="GauPro" data-id="loglikelihood"><a href='../../GauPro/html/GauPro.html#method-GauPro-loglikelihood'><code>GauPro::GauPro$loglikelihood()</code></a></span></li>
<li><span class="pkg-link" data-pkg="GauPro" data-topic="GauPro" data-id="maxEI"><a href='../../GauPro/html/GauPro.html#method-GauPro-maxEI'><code>GauPro::GauPro$maxEI()</code></a></span></li>
<li><span class="pkg-link" data-pkg="GauPro" data-topic="GauPro" data-id="maxEIwithfactors"><a href='../../GauPro/html/GauPro.html#method-GauPro-maxEIwithfactors'><code>GauPro::GauPro$maxEIwithfactors()</code></a></span></li>
<li><span class="pkg-link" data-pkg="GauPro" data-topic="GauPro" data-id="maxEIwithfactorsordiscrete"><a href='../../GauPro/html/GauPro.html#method-GauPro-maxEIwithfactorsordiscrete'><code>GauPro::GauPro$maxEIwithfactorsordiscrete()</code></a></span></li>
<li><span class="pkg-link" data-pkg="GauPro" data-topic="GauPro" data-id="maxqEI"><a href='../../GauPro/html/GauPro.html#method-GauPro-maxqEI'><code>GauPro::GauPro$maxqEI()</code></a></span></li>
<li><span class="pkg-link" data-pkg="GauPro" data-topic="GauPro" data-id="optim"><a href='../../GauPro/html/GauPro.html#method-GauPro-optim'><code>GauPro::GauPro$optim()</code></a></span></li>
<li><span class="pkg-link" data-pkg="GauPro" data-topic="GauPro" data-id="optimRestart"><a href='../../GauPro/html/GauPro.html#method-GauPro-optimRestart'><code>GauPro::GauPro$optimRestart()</code></a></span></li>
<li><span class="pkg-link" data-pkg="GauPro" data-topic="GauPro" data-id="param_optim_lower"><a href='../../GauPro/html/GauPro.html#method-GauPro-param_optim_lower'><code>GauPro::GauPro$param_optim_lower()</code></a></span></li>
<li><span class="pkg-link" data-pkg="GauPro" data-topic="GauPro" data-id="param_optim_start"><a href='../../GauPro/html/GauPro.html#method-GauPro-param_optim_start'><code>GauPro::GauPro$param_optim_start()</code></a></span></li>
<li><span class="pkg-link" data-pkg="GauPro" data-topic="GauPro" data-id="param_optim_start0"><a href='../../GauPro/html/GauPro.html#method-GauPro-param_optim_start0'><code>GauPro::GauPro$param_optim_start0()</code></a></span></li>
<li><span class="pkg-link" data-pkg="GauPro" data-topic="GauPro" data-id="param_optim_start_mat"><a href='../../GauPro/html/GauPro.html#method-GauPro-param_optim_start_mat'><code>GauPro::GauPro$param_optim_start_mat()</code></a></span></li>
<li><span class="pkg-link" data-pkg="GauPro" data-topic="GauPro" data-id="param_optim_upper"><a href='../../GauPro/html/GauPro.html#method-GauPro-param_optim_upper'><code>GauPro::GauPro$param_optim_upper()</code></a></span></li>
<li><span class="pkg-link" data-pkg="GauPro" data-topic="GauPro" data-id="plot"><a href='../../GauPro/html/GauPro.html#method-GauPro-plot'><code>GauPro::GauPro$plot()</code></a></span></li>
<li><span class="pkg-link" data-pkg="GauPro" data-topic="GauPro" data-id="plot1D"><a href='../../GauPro/html/GauPro.html#method-GauPro-plot1D'><code>GauPro::GauPro$plot1D()</code></a></span></li>
<li><span class="pkg-link" data-pkg="GauPro" data-topic="GauPro" data-id="plot2D"><a href='../../GauPro/html/GauPro.html#method-GauPro-plot2D'><code>GauPro::GauPro$plot2D()</code></a></span></li>
<li><span class="pkg-link" data-pkg="GauPro" data-topic="GauPro" data-id="plotLOO"><a href='../../GauPro/html/GauPro.html#method-GauPro-plotLOO'><code>GauPro::GauPro$plotLOO()</code></a></span></li>
<li><span class="pkg-link" data-pkg="GauPro" data-topic="GauPro" data-id="plot_track_optim"><a href='../../GauPro/html/GauPro.html#method-GauPro-plot_track_optim'><code>GauPro::GauPro$plot_track_optim()</code></a></span></li>
<li><span class="pkg-link" data-pkg="GauPro" data-topic="GauPro" data-id="plotmarginal"><a href='../../GauPro/html/GauPro.html#method-GauPro-plotmarginal'><code>GauPro::GauPro$plotmarginal()</code></a></span></li>
<li><span class="pkg-link" data-pkg="GauPro" data-topic="GauPro" data-id="plotmarginalrandom"><a href='../../GauPro/html/GauPro.html#method-GauPro-plotmarginalrandom'><code>GauPro::GauPro$plotmarginalrandom()</code></a></span></li>
<li><span class="pkg-link" data-pkg="GauPro" data-topic="GauPro" data-id="pred"><a href='../../GauPro/html/GauPro.html#method-GauPro-pred'><code>GauPro::GauPro$pred()</code></a></span></li>
<li><span class="pkg-link" data-pkg="GauPro" data-topic="GauPro" data-id="pred_LOO"><a href='../../GauPro/html/GauPro.html#method-GauPro-pred_LOO'><code>GauPro::GauPro$pred_LOO()</code></a></span></li>
<li><span class="pkg-link" data-pkg="GauPro" data-topic="GauPro" data-id="pred_mean"><a href='../../GauPro/html/GauPro.html#method-GauPro-pred_mean'><code>GauPro::GauPro$pred_mean()</code></a></span></li>
<li><span class="pkg-link" data-pkg="GauPro" data-topic="GauPro" data-id="pred_meanC"><a href='../../GauPro/html/GauPro.html#method-GauPro-pred_meanC'><code>GauPro::GauPro$pred_meanC()</code></a></span></li>
<li><span class="pkg-link" data-pkg="GauPro" data-topic="GauPro" data-id="pred_var"><a href='../../GauPro/html/GauPro.html#method-GauPro-pred_var'><code>GauPro::GauPro$pred_var()</code></a></span></li>
<li><span class="pkg-link" data-pkg="GauPro" data-topic="GauPro" data-id="pred_var_after_adding_points"><a href='../../GauPro/html/GauPro.html#method-GauPro-pred_var_after_adding_points'><code>GauPro::GauPro$pred_var_after_adding_points()</code></a></span></li>
<li><span class="pkg-link" data-pkg="GauPro" data-topic="GauPro" data-id="pred_var_after_adding_points_sep"><a href='../../GauPro/html/GauPro.html#method-GauPro-pred_var_after_adding_points_sep'><code>GauPro::GauPro$pred_var_after_adding_points_sep()</code></a></span></li>
<li><span class="pkg-link" data-pkg="GauPro" data-topic="GauPro" data-id="pred_var_reduction"><a href='../../GauPro/html/GauPro.html#method-GauPro-pred_var_reduction'><code>GauPro::GauPro$pred_var_reduction()</code></a></span></li>
<li><span class="pkg-link" data-pkg="GauPro" data-topic="GauPro" data-id="pred_var_reductions"><a href='../../GauPro/html/GauPro.html#method-GauPro-pred_var_reductions'><code>GauPro::GauPro$pred_var_reductions()</code></a></span></li>
<li><span class="pkg-link" data-pkg="GauPro" data-topic="GauPro" data-id="predict"><a href='../../GauPro/html/GauPro.html#method-GauPro-predict'><code>GauPro::GauPro$predict()</code></a></span></li>
<li><span class="pkg-link" data-pkg="GauPro" data-topic="GauPro" data-id="print"><a href='../../GauPro/html/GauPro.html#method-GauPro-print'><code>GauPro::GauPro$print()</code></a></span></li>
<li><span class="pkg-link" data-pkg="GauPro" data-topic="GauPro" data-id="sample"><a href='../../GauPro/html/GauPro.html#method-GauPro-sample'><code>GauPro::GauPro$sample()</code></a></span></li>
<li><span class="pkg-link" data-pkg="GauPro" data-topic="GauPro" data-id="summary"><a href='../../GauPro/html/GauPro.html#method-GauPro-summary'><code>GauPro::GauPro$summary()</code></a></span></li>
<li><span class="pkg-link" data-pkg="GauPro" data-topic="GauPro" data-id="update_K_and_estimates"><a href='../../GauPro/html/GauPro.html#method-GauPro-update_K_and_estimates'><code>GauPro::GauPro$update_K_and_estimates()</code></a></span></li>
<li><span class="pkg-link" data-pkg="GauPro" data-topic="GauPro" data-id="update_corrparams"><a href='../../GauPro/html/GauPro.html#method-GauPro-update_corrparams'><code>GauPro::GauPro$update_corrparams()</code></a></span></li>
<li><span class="pkg-link" data-pkg="GauPro" data-topic="GauPro" data-id="update_data"><a href='../../GauPro/html/GauPro.html#method-GauPro-update_data'><code>GauPro::GauPro$update_data()</code></a></span></li>
<li><span class="pkg-link" data-pkg="GauPro" data-topic="GauPro" data-id="update_fast"><a href='../../GauPro/html/GauPro.html#method-GauPro-update_fast'><code>GauPro::GauPro$update_fast()</code></a></span></li>
<li><span class="pkg-link" data-pkg="GauPro" data-topic="GauPro" data-id="update_nugget"><a href='../../GauPro/html/GauPro.html#method-GauPro-update_nugget'><code>GauPro::GauPro$update_nugget()</code></a></span></li>
<li><span class="pkg-link" data-pkg="GauPro" data-topic="GauPro" data-id="update_params"><a href='../../GauPro/html/GauPro.html#method-GauPro-update_params'><code>GauPro::GauPro$update_params()</code></a></span></li>
</ul>
</details>
}}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-GauPro_kernel_model_LOO-new"></a>}}
\if{latex}{\out{\hypertarget{method-GauPro_kernel_model_LOO-new}{}}}
\subsection{Method \code{new()}}{
Create a kernel model that uses a leave-one-out GP model
to fix the standard error predictions.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{GauPro_kernel_model_LOO$new(..., LOO_kernel, LOO_options = list())}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{...}}{Passed to super$initialize.}

\item{\code{LOO_kernel}}{The kernel that should be used for the
leave-one-out model. Shouldn't be too smooth.}

\item{\code{LOO_options}}{Options passed to the leave-one-out model.}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-GauPro_kernel_model_LOO-update"></a>}}
\if{latex}{\out{\hypertarget{method-GauPro_kernel_model_LOO-update}{}}}
\subsection{Method \code{update()}}{
Update the model. Should only give in
(Xnew and Znew) or (Xall and Zall).
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{GauPro_kernel_model_LOO$update(
  Xnew = NULL,
  Znew = NULL,
  Xall = NULL,
  Zall = NULL,
  restarts = 5,
  param_update = self$param.est,
  nug.update = self$nug.est,
  no_update = FALSE
)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{Xnew}}{New X values to add.}

\item{\code{Znew}}{New Z values to add.}

\item{\code{Xall}}{All X values to be used. Will replace existing X.}

\item{\code{Zall}}{All Z values to be used. Will replace existing Z.}

\item{\code{restarts}}{Number of optimization restarts.}

\item{\code{param_update}}{Are the parameters being updated?}

\item{\code{nug.update}}{Is the nugget being updated?}

\item{\code{no_update}}{Are no parameters being updated?}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-GauPro_kernel_model_LOO-pred_one_matrix"></a>}}
\if{latex}{\out{\hypertarget{method-GauPro_kernel_model_LOO-pred_one_matrix}{}}}
\subsection{Method \code{pred_one_matrix()}}{
Predict for a matrix of points
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{GauPro_kernel_model_LOO$pred_one_matrix(
  XX,
  se.fit = F,
  covmat = F,
  return_df = FALSE,
  mean_dist = FALSE
)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{XX}}{points to predict at}

\item{\code{se.fit}}{Should standard error be returned?}

\item{\code{covmat}}{Should covariance matrix be returned?}

\item{\code{return_df}}{When returning se.fit, should it be returned in
a data frame?}

\item{\code{mean_dist}}{Should mean distribution be returned?}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-GauPro_kernel_model_LOO-clone"></a>}}
\if{latex}{\out{\hypertarget{method-GauPro_kernel_model_LOO-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{GauPro_kernel_model_LOO$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
