% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/EstRegime.R
\name{EstRegime}
\alias{EstRegime}
\title{Estimated Regimes for the univariate Gaussian HMM}
\usage{
EstRegime(t, y, lambda, eta)
}
\arguments{
\item{t}{(nx1) vector of dates (years, ...); if no dates then t=[1:length(y)]}

\item{y}{(nx1) vector of data;}

\item{lambda}{(nxreg) probabilities of being in regime k at time t given all observations;}

\item{eta}{(nxreg) probabilities of being in regime k at time t given observations up to time t;}
}
\value{
\item{A}{Estimated Regime using lambda}

\item{B}{Estimated Regime using eta}

\item{runsA}{Estimated number of runs using lambda}

\item{runsB}{Estimated number of runs using eta}

\item{pA}{Graph for the estimated regime for each observation using lambda}

\item{pB}{Graph for the estimated regime for each observation using eta}
}
\description{
This function computes and plots the most likely regime for univariate Gaussian HMM using
probabilities of being in regime k at time t given all observations (lambda)
and probabilities of being in regime k at time t given observations up to time t (eta).
}
\examples{
 Q <- matrix(c(0.8, 0.3, 0.2, 0.7),2,2); mu <- c(-0.3 ,0.7) ; sigma <- c(0.15,0.05);
data <- Sim.HMM.Gaussian.1d(mu,sigma,Q,eta0=1,100)$x
t=c(1:100);
est <- EstHMM1d(data, 2, max_iter=10000, prec=0.0001)
EstRegime(t,data,est$lambda, est$eta)

}
\references{
Chapter 10.2 of B. Rémillard (2013). Statistical Methods for Financial Engineering,
Chapman and Hall/CRC Financial Mathematics Series, Taylor & Francis.
}
\author{
Bouchra R Nasri  and Bruno N Rémillard, January 31, 2019
}
