% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/PlotLongLat.R
\name{PlotLongLat}
\alias{PlotLongLat}
\title{To plot using Geographic coordinate WGS84.}
\usage{
PlotLongLat(longlat_df)
}
\arguments{
\item{longlat_df}{Point name, Sexagesimal longitude and latitude as dataframe.}
}
\value{
leaflet map.
}
\description{
With this function it is possible to plot using Longitude and Latitude (Geographic coordinate WGS84).
}
\examples{
# Point name
Pto <- "St1"

# Longitude
g <- -71
m <- 18
s <- 44.86475

# Value in sexagesimal
sexa_long <- sexagesimal(g, m, s)

# Latitude
g1 <- -33
m1 <- 12
s1 <- 27.11457

# Value in sexagesimal
sexa_lat <- sexagesimal(g1, m1, s1)

# Longitude and Latitude as data.frame
longlat_df <- data.frame(Pto,sexa_long,sexa_lat)

value <- PlotLongLat(longlat_df)
print(value)
}
\seealso{
\code{data.frame}
}
