% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot.foreccomb_res.R
\name{plot.foreccomb_res}
\alias{plot.foreccomb_res}
\title{Plot results from forecast combination model}
\usage{
\method{plot}{foreccomb_res}(x, which = 1, ...)
}
\arguments{
\item{x}{An object of class 'foreccomb_res'.}

\item{which}{Type of plot: 1 = actual vs. fitted, 2 = combination weights.}

\item{...}{Other arguments passing to \code{\link[graphics]{plot.default}}.}
}
\value{
A plot for the foreccomb_res class.
}
\description{
Produces plots for the results of a forecast combination method. Either
an actual vs. fitted plot (\code{which = 1}) or a barplot of the combination weights
(\code{which = 2}).
}
\examples{
obs <- rnorm(100)
preds <- matrix(rnorm(1000, 1), 100, 10)
train_o<-obs[1:80]
train_p<-preds[1:80,]
test_o<-obs[81:100]
test_p<-preds[81:100,]

data<-foreccomb(train_o, train_p, test_o, test_p)
fit <- comb_EIG1(data)
plot(fit)

}
\author{
Christoph E. Weiss and Gernot R. Roetzer
}
\seealso{
\code{\link[GeomComb]{foreccomb}},
\code{\link[GeomComb]{summary.foreccomb_res}}
}

