% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ger_boxp.R
\name{ger_boxp}
\alias{ger_boxp}
\title{Boxplot graphic}
\usage{
ger_boxp(
  data,
  x,
  y,
  group = NULL,
  xlab = NULL,
  ylab = NULL,
  glab = NULL,
  ylimits = NULL,
  xrotation = NULL,
  legend = "top",
  xtext = NULL,
  gtext = NULL,
  opt = NULL
)
}
\arguments{
\item{data}{raw data}

\item{x}{Axis x variable}

\item{y}{Axis y variable}

\item{group}{Group variable}

\item{xlab}{Title for the axis x}

\item{ylab}{Title for the axis y}

\item{glab}{Title for the legend}

\item{ylimits}{Limitis and break of the y axis c(init, end, brakes)}

\item{xrotation}{Rotation in x axis c(angle, h, v)}

\item{legend}{the position of legends ("none", "left", "right", "bottom",
"top", or two-element numeric vector)}

\item{xtext}{Text labels in x axis}

\item{gtext}{Text labels in groups}

\item{opt}{Add news layer to the plot}
}
\value{
boxplot
}
\description{
Function use the raw data for made a boxplot graphic
}
\examples{

\dontrun{

library(GerminaR)

fb <- ger_summary(SeedN = "seeds", evalName = "D", data = prosopis)

ger_boxp(data = fb
         , x =  "nacl"
         , y = "grp"
         , group = "temp"
         )

}

}
