% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/distDiffTest.R
\name{distDiffTest}
\alias{distDiffTest}
\title{R function for testing the difference in distance of two point feature datasets to
a target feature dataset}
\usage{
distDiffTest(feat1, feat2, to.feat, feat1.lab = NULL, feat2.lab = NULL,
  B = 999)
}
\arguments{
\item{feat1}{Point pattern to be tested (of point type; 'SpatialPointsDataFrame' class).}

\item{feat2}{Second point pattern to be tested (of point type; 'SpatialPointsDataFrame' class).}

\item{to.feat}{Target feature (point, polyline, or polygon type; 'SpatialPointsDataFrame',
'SpatialLinesDataFrame', 'SpatialPolygonsDataFrame' class).}

\item{feat1.lab}{Label to be used in the returned chart to indicate the 'feat1' (default: smpl 1).}

\item{feat2.lab}{Label to be used in the returned chart to indicate the 'feat2' (default: smpl 2).}

\item{B}{Desired number of permutations (set at 999 by default).}
}
\value{
The frequency histogram returned by the function displays the distribution of the
permuted mean difference between the two samples; a solid dot indicates the observed mean
difference, while an hollow dot represents the mean of the permuted differences.
Two dashed blue lines indicates the 0.025 and 0.975 percentile of the permuted
distribution. A rug plot at the bottom histgram indicates the individual permuted mean
differences. At the bottom of the chart, some information are displayed.
In particular, the observed mean difference and the permuted p-values are reported.
In the last row, the result of the regular (parametric) t-test (both assuming and
not assuming equal variances) is reported to allow users to compare the outcome of
these different versions of the test.
}
\description{
The function allows to perform a permutation-based t-test to test the difference in distance
of two point feature datasets to a target feature dataset.
The latter can consist of either points, a lines, or polygons.
}
\details{
Under the hood, the function relies on the perm.t.test() function out of this same package.
First, for each feature of both patterns, the distance to the nearest
target feature is calculated; for each set of features, the distances
are eventually averaged; the observed difference between the two averages
is stored. Then, the individual observed nearest distances are randomly assigned
to either group; the re-assignment is performed B times (999 by default) and each time
the difference between the two averages is calculated.
The distribution of these permuted average differenes represents the distribution of that
statistic under the Null Hypothesis of no difference in distance to the target feature.
One-sided and two-sided p-values are reported.\cr
}
\examples{
#test the difference in distance of two sets of points to the nearest geological fault
distDiffTest(feat1=springs, feat2=points, to.feat=faults, B=299)

}
\seealso{
\code{\link{perm.t.test}}
}
\keyword{distDiffTest}
