% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/time2spanTxt.R
\name{time2spanTxt}
\alias{time2spanTxt}
\title{A dense time-span text}
\usage{
time2spanTxt(
  times,
  day_month_glue_txt = getOption("Gmisc_time2spanTxt_day_month", default =
    "{mday(time)} {month(time, label = TRUE)}"),
  full_year_format = getOption("Gmisc_time2spanTxt_full_year", default =
    "{mday(time)} {month(time, label = TRUE)} {year(time)}"),
  start_stop_glue_txt = getOption("Gmisc_time2spanTxt_template", default =
    "{start} to {stop}")
)
}
\arguments{
\item{times}{The dates or posix timestamps to used for timespan}

\item{day_month_glue_txt}{The \code{\link[glue]{glue}} string to format days and months with \code{time} as the time input}

\item{full_year_format}{The \code{\link[glue]{glue}} string to format the full year with \code{time} as the time input}

\item{start_stop_glue_txt}{The string used in the \code{\link[glue]{glue}} for putting the
start and stop dates together into one string}
}
\value{
\code{string} A string describing the time span
}
\description{
When adding a time span text we often don't want to write \emph{3 jun - 10 jun} but
shorten it to \emph{3 - 10 jun} while retaining month and year info only if the span
crosses between months or years.
}
\details{
There are options that can be set using the \code{\link[base]{option}}:
\itemize{
\item \code{Gmisc_time2spanTxt_day_month} The date with day + month as formatted by \code{\link[glue]{glue}} where the time is passed as \code{time}.
\item \code{Gmisc_time2spanTxt_full_year} The full date with day + month + year as formatted by \code{\link[glue]{glue}} where the time is passed as \code{time}.
\item \code{Gmisc_time2spanTxt_template} The merge of the stop & start elements using \code{\link[glue]{glue}}.
}
}
\examples{
time2spanTxt(as.POSIXct(c("2020-01-02", "2020-03-01", NA)))
# 2 jan to 1 mar

}
