% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils.R
\name{rename_col}
\alias{rename_col}
\title{Rename Columns in a Data Frame (Internal)}
\usage{
rename_col(df, rename_cols)
}
\arguments{
\item{df}{A data frame containing columns to be renamed.}

\item{rename_cols}{A named vector where names are existing column names,
and values are the corresponding new names.}
}
\value{
A modified data frame with renamed columns.
}
\description{
A helper function that renames columns in a data frame based on a specified mapping.
Used internally in \code{get_var_structure()}, \code{get_data_by_dims()}, and \code{rename_dims()}.
}
\details{
\itemize{
\item Replaces column names according to the provided \code{rename_cols} mapping.
\item Ensures no duplicate column names by appending numerical suffixes when necessary.
\item Helps standardize column names across SL4 and HAR datasets.
}
}
\seealso{
\code{\link{get_var_structure}}, \code{\link{get_data_by_dims}}, \code{\link{rename_dims}}
}
\author{
Pattawee Puangchit
}
\keyword{internal}
