% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/apca.R
\name{apca}
\alias{apca}
\title{ANOVA Principal Component Analysis - APCA}
\usage{
apca(formula, data, add_error = TRUE, contrasts = "contr.sum", ...)
}
\arguments{
\item{formula}{Model formula accepting a single response (block) and predictors.}

\item{data}{The data set to analyse.}

\item{add_error}{Add error to LS means (default = TRUE).}

\item{contrasts}{Effect coding: "sum" (default = sum-coding), "weighted", "reference", "treatment".}

\item{...}{Additional parameters for the asca_fit function.}
}
\value{
An object of class \code{apca}, inheriting from the general \code{asca} class.
Further arguments and plots can be found in the \code{\link{asca}} documentation.
}
\description{
APCA function for fitting ANOVA Principal Component Analysis models.
}
\examples{
data(candies)
ap <- apca(assessment ~ candy, data=candies)
scoreplot(ap)

# Numeric effects
candies$num <- eff <- 1:165
mod <- apca(assessment ~ candy + assessor + num, data=candies)
summary(mod)
scoreplot(mod, factor=3, gr.col=rgb(eff/max(eff), 1-eff/max(eff),0), pch.scores="x")
}
\references{
Harrington, P.d.B., Vieira, N.E., Espinoza, J., Nien, J.K., Romero, R., and Yergey, A.L. (2005)
Analysis of variance–principal component analysis: A soft tool for proteomic discovery.
Analytica chimica acta, 544 (1-2), 118–127.
}
\seealso{
Main methods: \code{\link{asca}}, \code{\link{apca}}, \code{\link{limmpca}}, \code{\link{msca}}, \code{\link{pcanova}}, \code{\link{prc}} and \code{\link{permanova}}.
Workhorse function underpinning most methods: \code{\link{asca_fit}}.
Extraction of results and plotting: \code{\link{asca_results}}, \code{\link{asca_plots}}, \code{\link{pcanova_results}} and \code{\link{pcanova_plots}}
}
