% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/CI_single.R
\name{CI_single}
\alias{CI_single}
\title{Global confidence interval treshold from experimental standard deviation for 1 sample}
\usage{
CI_single(s1, replicates = 3)
}
\arguments{
\item{s1}{standard deviation from one sample}

\item{replicates}{number of replicates. Default set to 3.}
}
\value{
treshold for determining significance.
}
\description{
Calculation of global confidence interval using approach by:
Reliable Identification of Significant Differences in Differential Hydrogen Exchange-Mass Spectrometry Measurements Using a Hybrid Significance Testing Approach
Tyler S. Hageman and David D. Weis
Analytical Chemistry 2019 91 (13), 8008-8016 DOI: 10.1021/acs.analchem.9b01325
calculations for alpha 0.99
}
\examples{
sd1<-data.frame(c(0.1, 0.12, 0.13, 0.09, 0.11, 0.10))
CI_single(s1=sd1, replicates=3)
}
