% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sd_ave_diff_pv_tp.R
\name{ave_timepoint}
\alias{ave_timepoint}
\title{Returns average value for either uptake of procent data.}
\usage{
ave_timepoint(df, replicates = 3)
}
\arguments{
\item{df}{output from functions output_tp or output_tp_proc.}

\item{replicates}{number of replicates used. Default is set to replicates=3}
}
\value{
Data.frame with average values
}
\description{
Calculates average of uptake or procent data. Returns data frame with average values.
Default for the number of replicates is 3.
}
\examples{
file_nm<-system.file("extdata", "All_results_table.csv", package = "HDXBoxeR")
a<- output_tp(file_nm)
ave<-ave_timepoint(df=a) ##if number of replicates is equal 3
ave<-ave_timepoint(df=a, replicates=4) ##if number of replicates is equal 4
}
